<?php

namespace fk_\EnumType;

/**
 * This class stands for KCariMailTuru EnumType
 * @subpackage Enumerations
 */
class KCariMailTuru
{
    /**
     * Constant for value 'Teslimat'
     * @return string 'Teslimat'
     */
    const VALUE_TESLIMAT = 'Teslimat';
    /**
     * Constant for value 'Tahsilat'
     * @return string 'Tahsilat'
     */
    const VALUE_TAHSILAT = 'Tahsilat';
    /**
     * Constant for value 'Hepsi'
     * @return string 'Hepsi'
     */
    const VALUE_HEPSI = 'Hepsi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TESLIMAT
     * @uses self::VALUE_TAHSILAT
     * @uses self::VALUE_HEPSI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TESLIMAT,
            self::VALUE_TAHSILAT,
            self::VALUE_HEPSI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
