<?php

namespace fk_\EnumType;

/**
 * This class stands for CariBlokeTipi EnumType
 * @subpackage Enumerations
 */
class CariBlokeTipi
{
    /**
     * Constant for value 'KendindenBloke'
     * @return string 'KendindenBloke'
     */
    const VALUE_KENDINDEN_BLOKE = 'KendindenBloke';
    /**
     * Constant for value 'UstCarisindenBloke'
     * @return string 'UstCarisindenBloke'
     */
    const VALUE_UST_CARISINDEN_BLOKE = 'UstCarisindenBloke';
    /**
     * Constant for value 'KonsolidedenBloke'
     * @return string 'KonsolidedenBloke'
     */
    const VALUE_KONSOLIDEDEN_BLOKE = 'KonsolidedenBloke';
    /**
     * Constant for value 'TopluBloke'
     * @return string 'TopluBloke'
     */
    const VALUE_TOPLU_BLOKE = 'TopluBloke';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KENDINDEN_BLOKE
     * @uses self::VALUE_UST_CARISINDEN_BLOKE
     * @uses self::VALUE_KONSOLIDEDEN_BLOKE
     * @uses self::VALUE_TOPLU_BLOKE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KENDINDEN_BLOKE,
            self::VALUE_UST_CARISINDEN_BLOKE,
            self::VALUE_KONSOLIDEDEN_BLOKE,
            self::VALUE_TOPLU_BLOKE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
