<?php

namespace fk_\EnumType;

/**
 * This class stands for AracYakitTip EnumType
 * @subpackage Enumerations
 */
class AracYakitTip
{
    /**
     * Constant for value 'Dizel'
     * @return string 'Dizel'
     */
    const VALUE_DIZEL = 'Dizel';
    /**
     * Constant for value 'Benzin'
     * @return string 'Benzin'
     */
    const VALUE_BENZIN = 'Benzin';
    /**
     * Constant for value 'LPG'
     * @return string 'LPG'
     */
    const VALUE_LPG = 'LPG';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIZEL
     * @uses self::VALUE_BENZIN
     * @uses self::VALUE_LPG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIZEL,
            self::VALUE_BENZIN,
            self::VALUE_LPG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
