<?php

namespace fk_\EnumType;

/**
 * This class stands for SubeTipTur EnumType
 * @subpackage Enumerations
 */
class SubeTipTur
{
    /**
     * Constant for value 'Standart'
     * @return string 'Standart'
     */
    const VALUE_STANDART = 'Standart';
    /**
     * Constant for value 'Nokta'
     * @return string 'Nokta'
     */
    const VALUE_NOKTA = 'Nokta';
    /**
     * Constant for value 'Acente'
     * @return string 'Acente'
     */
    const VALUE_ACENTE = 'Acente';
    /**
     * Constant for value 'Operasyon'
     * @return string 'Operasyon'
     */
    const VALUE_OPERASYON = 'Operasyon';
    /**
     * Constant for value 'Mobil'
     * @return string 'Mobil'
     */
    const VALUE_MOBIL = 'Mobil';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDART
     * @uses self::VALUE_NOKTA
     * @uses self::VALUE_ACENTE
     * @uses self::VALUE_OPERASYON
     * @uses self::VALUE_MOBIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDART,
            self::VALUE_NOKTA,
            self::VALUE_ACENTE,
            self::VALUE_OPERASYON,
            self::VALUE_MOBIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
