<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CariSevkAdresi StructType
 * @subpackage Structs
 */
class CariSevkAdresi extends SerendipEntity
{
    /**
     * The SatirNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SatirNo;
    /**
     * The ETicaretSiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ETicaretSiteID;
    /**
     * The SinerjiB2CSchoolId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SinerjiB2CSchoolId;
    /**
     * The AktarimEvrakTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AktarimEvrakTuru;
    /**
     * The Varsayilan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Varsayilan;
    /**
     * The KaraListede
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KaraListede;
    /**
     * The BlokeDurumda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BlokeDurumda;
    /**
     * The KargoCariObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KargoCariObjId;
    /**
     * The KargoSevkHesabi_ObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KargoSevkHesabi_ObjId;
    /**
     * The KargoyaGonderildimi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KargoyaGonderildimi;
    /**
     * The KargodanGeldiMi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KargodanGeldiMi;
    /**
     * The Cari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\CariHesabiPointer
     */
    public $Cari;
    /**
     * The SevkAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\Adres
     */
    public $SevkAdresi;
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kod;
    /**
     * The Unvan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unvan;
    /**
     * The Telefon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefon;
    /**
     * The ePosta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ePosta;
    /**
     * The SinerjiB2CSchoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SinerjiB2CSchoolName;
    /**
     * The SatisElemani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\SatisElemaniPointer
     */
    public $SatisElemani;
    /**
     * The RefOzelGrup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\GrupPointer
     */
    public $RefOzelGrup;
    /**
     * The TCNumarasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TCNumarasi;
    /**
     * The VergiDairesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VergiDairesi;
    /**
     * The KargoCariKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KargoCariKodu;
    /**
     * The KargoSubesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KargoSubesi;
    /**
     * The KargoAktarmasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KargoAktarmasi;
    /**
     * Constructor method for CariSevkAdresi
     * @uses CariSevkAdresi::setSatirNo()
     * @uses CariSevkAdresi::setETicaretSiteID()
     * @uses CariSevkAdresi::setSinerjiB2CSchoolId()
     * @uses CariSevkAdresi::setAktarimEvrakTuru()
     * @uses CariSevkAdresi::setVarsayilan()
     * @uses CariSevkAdresi::setKaraListede()
     * @uses CariSevkAdresi::setBlokeDurumda()
     * @uses CariSevkAdresi::setKargoCariObjId()
     * @uses CariSevkAdresi::setKargoSevkHesabi_ObjId()
     * @uses CariSevkAdresi::setKargoyaGonderildimi()
     * @uses CariSevkAdresi::setKargodanGeldiMi()
     * @uses CariSevkAdresi::setCari()
     * @uses CariSevkAdresi::setSevkAdresi()
     * @uses CariSevkAdresi::setKod()
     * @uses CariSevkAdresi::setUnvan()
     * @uses CariSevkAdresi::setTelefon()
     * @uses CariSevkAdresi::setEPosta()
     * @uses CariSevkAdresi::setSinerjiB2CSchoolName()
     * @uses CariSevkAdresi::setSatisElemani()
     * @uses CariSevkAdresi::setRefOzelGrup()
     * @uses CariSevkAdresi::setTCNumarasi()
     * @uses CariSevkAdresi::setVergiDairesi()
     * @uses CariSevkAdresi::setKargoCariKodu()
     * @uses CariSevkAdresi::setKargoSubesi()
     * @uses CariSevkAdresi::setKargoAktarmasi()
     * @param int $satirNo
     * @param int $eTicaretSiteID
     * @param int $sinerjiB2CSchoolId
     * @param string $aktarimEvrakTuru
     * @param bool $varsayilan
     * @param bool $karaListede
     * @param bool $blokeDurumda
     * @param int $kargoCariObjId
     * @param int $kargoSevkHesabi_ObjId
     * @param string $kargoyaGonderildimi
     * @param string $kargodanGeldiMi
     * @param \fk_\StructType\CariHesabiPointer $cari
     * @param \fk_\StructType\Adres $sevkAdresi
     * @param string $kod
     * @param string $unvan
     * @param string $telefon
     * @param string $ePosta
     * @param string $sinerjiB2CSchoolName
     * @param \fk_\StructType\SatisElemaniPointer $satisElemani
     * @param \fk_\StructType\GrupPointer $refOzelGrup
     * @param string $tCNumarasi
     * @param string $vergiDairesi
     * @param string $kargoCariKodu
     * @param string $kargoSubesi
     * @param string $kargoAktarmasi
     */
    public function __construct($satirNo = null, $eTicaretSiteID = null, $sinerjiB2CSchoolId = null, $aktarimEvrakTuru = null, $varsayilan = null, $karaListede = null, $blokeDurumda = null, $kargoCariObjId = null, $kargoSevkHesabi_ObjId = null, $kargoyaGonderildimi = null, $kargodanGeldiMi = null, \fk_\StructType\CariHesabiPointer $cari = null, \fk_\StructType\Adres $sevkAdresi = null, $kod = null, $unvan = null, $telefon = null, $ePosta = null, $sinerjiB2CSchoolName = null, \fk_\StructType\SatisElemaniPointer $satisElemani = null, \fk_\StructType\GrupPointer $refOzelGrup = null, $tCNumarasi = null, $vergiDairesi = null, $kargoCariKodu = null, $kargoSubesi = null, $kargoAktarmasi = null)
    {
        $this
            ->setSatirNo($satirNo)
            ->setETicaretSiteID($eTicaretSiteID)
            ->setSinerjiB2CSchoolId($sinerjiB2CSchoolId)
            ->setAktarimEvrakTuru($aktarimEvrakTuru)
            ->setVarsayilan($varsayilan)
            ->setKaraListede($karaListede)
            ->setBlokeDurumda($blokeDurumda)
            ->setKargoCariObjId($kargoCariObjId)
            ->setKargoSevkHesabi_ObjId($kargoSevkHesabi_ObjId)
            ->setKargoyaGonderildimi($kargoyaGonderildimi)
            ->setKargodanGeldiMi($kargodanGeldiMi)
            ->setCari($cari)
            ->setSevkAdresi($sevkAdresi)
            ->setKod($kod)
            ->setUnvan($unvan)
            ->setTelefon($telefon)
            ->setEPosta($ePosta)
            ->setSinerjiB2CSchoolName($sinerjiB2CSchoolName)
            ->setSatisElemani($satisElemani)
            ->setRefOzelGrup($refOzelGrup)
            ->setTCNumarasi($tCNumarasi)
            ->setVergiDairesi($vergiDairesi)
            ->setKargoCariKodu($kargoCariKodu)
            ->setKargoSubesi($kargoSubesi)
            ->setKargoAktarmasi($kargoAktarmasi);
    }
    /**
     * Get SatirNo value
     * @return int
     */
    public function getSatirNo()
    {
        return $this->SatirNo;
    }
    /**
     * Set SatirNo value
     * @param int $satirNo
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setSatirNo($satirNo = null)
    {
        // validation for constraint: int
        if (!is_null($satirNo) && !(is_int($satirNo) || ctype_digit($satirNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($satirNo, true), gettype($satirNo)), __LINE__);
        }
        $this->SatirNo = $satirNo;
        return $this;
    }
    /**
     * Get ETicaretSiteID value
     * @return int
     */
    public function getETicaretSiteID()
    {
        return $this->ETicaretSiteID;
    }
    /**
     * Set ETicaretSiteID value
     * @param int $eTicaretSiteID
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setETicaretSiteID($eTicaretSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($eTicaretSiteID) && !(is_int($eTicaretSiteID) || ctype_digit($eTicaretSiteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eTicaretSiteID, true), gettype($eTicaretSiteID)), __LINE__);
        }
        $this->ETicaretSiteID = $eTicaretSiteID;
        return $this;
    }
    /**
     * Get SinerjiB2CSchoolId value
     * @return int
     */
    public function getSinerjiB2CSchoolId()
    {
        return $this->SinerjiB2CSchoolId;
    }
    /**
     * Set SinerjiB2CSchoolId value
     * @param int $sinerjiB2CSchoolId
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setSinerjiB2CSchoolId($sinerjiB2CSchoolId = null)
    {
        // validation for constraint: int
        if (!is_null($sinerjiB2CSchoolId) && !(is_int($sinerjiB2CSchoolId) || ctype_digit($sinerjiB2CSchoolId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sinerjiB2CSchoolId, true), gettype($sinerjiB2CSchoolId)), __LINE__);
        }
        $this->SinerjiB2CSchoolId = $sinerjiB2CSchoolId;
        return $this;
    }
    /**
     * Get AktarimEvrakTuru value
     * @return string
     */
    public function getAktarimEvrakTuru()
    {
        return $this->AktarimEvrakTuru;
    }
    /**
     * Set AktarimEvrakTuru value
     * @uses \fk_\EnumType\AktarimEvrakTuru::valueIsValid()
     * @uses \fk_\EnumType\AktarimEvrakTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aktarimEvrakTuru
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setAktarimEvrakTuru($aktarimEvrakTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\AktarimEvrakTuru::valueIsValid($aktarimEvrakTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\AktarimEvrakTuru', is_array($aktarimEvrakTuru) ? implode(', ', $aktarimEvrakTuru) : var_export($aktarimEvrakTuru, true), implode(', ', \fk_\EnumType\AktarimEvrakTuru::getValidValues())), __LINE__);
        }
        $this->AktarimEvrakTuru = $aktarimEvrakTuru;
        return $this;
    }
    /**
     * Get Varsayilan value
     * @return bool
     */
    public function getVarsayilan()
    {
        return $this->Varsayilan;
    }
    /**
     * Set Varsayilan value
     * @param bool $varsayilan
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setVarsayilan($varsayilan = null)
    {
        // validation for constraint: boolean
        if (!is_null($varsayilan) && !is_bool($varsayilan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($varsayilan, true), gettype($varsayilan)), __LINE__);
        }
        $this->Varsayilan = $varsayilan;
        return $this;
    }
    /**
     * Get KaraListede value
     * @return bool
     */
    public function getKaraListede()
    {
        return $this->KaraListede;
    }
    /**
     * Set KaraListede value
     * @param bool $karaListede
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKaraListede($karaListede = null)
    {
        // validation for constraint: boolean
        if (!is_null($karaListede) && !is_bool($karaListede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($karaListede, true), gettype($karaListede)), __LINE__);
        }
        $this->KaraListede = $karaListede;
        return $this;
    }
    /**
     * Get BlokeDurumda value
     * @return bool
     */
    public function getBlokeDurumda()
    {
        return $this->BlokeDurumda;
    }
    /**
     * Set BlokeDurumda value
     * @param bool $blokeDurumda
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setBlokeDurumda($blokeDurumda = null)
    {
        // validation for constraint: boolean
        if (!is_null($blokeDurumda) && !is_bool($blokeDurumda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blokeDurumda, true), gettype($blokeDurumda)), __LINE__);
        }
        $this->BlokeDurumda = $blokeDurumda;
        return $this;
    }
    /**
     * Get KargoCariObjId value
     * @return int
     */
    public function getKargoCariObjId()
    {
        return $this->KargoCariObjId;
    }
    /**
     * Set KargoCariObjId value
     * @param int $kargoCariObjId
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargoCariObjId($kargoCariObjId = null)
    {
        // validation for constraint: int
        if (!is_null($kargoCariObjId) && !(is_int($kargoCariObjId) || ctype_digit($kargoCariObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kargoCariObjId, true), gettype($kargoCariObjId)), __LINE__);
        }
        $this->KargoCariObjId = $kargoCariObjId;
        return $this;
    }
    /**
     * Get KargoSevkHesabi_ObjId value
     * @return int
     */
    public function getKargoSevkHesabi_ObjId()
    {
        return $this->KargoSevkHesabi_ObjId;
    }
    /**
     * Set KargoSevkHesabi_ObjId value
     * @param int $kargoSevkHesabi_ObjId
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargoSevkHesabi_ObjId($kargoSevkHesabi_ObjId = null)
    {
        // validation for constraint: int
        if (!is_null($kargoSevkHesabi_ObjId) && !(is_int($kargoSevkHesabi_ObjId) || ctype_digit($kargoSevkHesabi_ObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kargoSevkHesabi_ObjId, true), gettype($kargoSevkHesabi_ObjId)), __LINE__);
        }
        $this->KargoSevkHesabi_ObjId = $kargoSevkHesabi_ObjId;
        return $this;
    }
    /**
     * Get KargoyaGonderildimi value
     * @return string
     */
    public function getKargoyaGonderildimi()
    {
        return $this->KargoyaGonderildimi;
    }
    /**
     * Set KargoyaGonderildimi value
     * @uses \fk_\EnumType\KargoyaGonderildimi::valueIsValid()
     * @uses \fk_\EnumType\KargoyaGonderildimi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kargoyaGonderildimi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargoyaGonderildimi($kargoyaGonderildimi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KargoyaGonderildimi::valueIsValid($kargoyaGonderildimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KargoyaGonderildimi', is_array($kargoyaGonderildimi) ? implode(', ', $kargoyaGonderildimi) : var_export($kargoyaGonderildimi, true), implode(', ', \fk_\EnumType\KargoyaGonderildimi::getValidValues())), __LINE__);
        }
        $this->KargoyaGonderildimi = $kargoyaGonderildimi;
        return $this;
    }
    /**
     * Get KargodanGeldiMi value
     * @return string
     */
    public function getKargodanGeldiMi()
    {
        return $this->KargodanGeldiMi;
    }
    /**
     * Set KargodanGeldiMi value
     * @uses \fk_\EnumType\KargodanGeldimi::valueIsValid()
     * @uses \fk_\EnumType\KargodanGeldimi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kargodanGeldiMi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargodanGeldiMi($kargodanGeldiMi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KargodanGeldimi::valueIsValid($kargodanGeldiMi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KargodanGeldimi', is_array($kargodanGeldiMi) ? implode(', ', $kargodanGeldiMi) : var_export($kargodanGeldiMi, true), implode(', ', \fk_\EnumType\KargodanGeldimi::getValidValues())), __LINE__);
        }
        $this->KargodanGeldiMi = $kargodanGeldiMi;
        return $this;
    }
    /**
     * Get Cari value
     * @return \fk_\StructType\CariHesabiPointer|null
     */
    public function getCari()
    {
        return $this->Cari;
    }
    /**
     * Set Cari value
     * @param \fk_\StructType\CariHesabiPointer $cari
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setCari(\fk_\StructType\CariHesabiPointer $cari = null)
    {
        $this->Cari = $cari;
        return $this;
    }
    /**
     * Get SevkAdresi value
     * @return \fk_\StructType\Adres|null
     */
    public function getSevkAdresi()
    {
        return $this->SevkAdresi;
    }
    /**
     * Set SevkAdresi value
     * @param \fk_\StructType\Adres $sevkAdresi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setSevkAdresi(\fk_\StructType\Adres $sevkAdresi = null)
    {
        $this->SevkAdresi = $sevkAdresi;
        return $this;
    }
    /**
     * Get Kod value
     * @return string|null
     */
    public function getKod()
    {
        return $this->Kod;
    }
    /**
     * Set Kod value
     * @param string $kod
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKod($kod = null)
    {
        // validation for constraint: string
        if (!is_null($kod) && !is_string($kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->Kod = $kod;
        return $this;
    }
    /**
     * Get Unvan value
     * @return string|null
     */
    public function getUnvan()
    {
        return $this->Unvan;
    }
    /**
     * Set Unvan value
     * @param string $unvan
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setUnvan($unvan = null)
    {
        // validation for constraint: string
        if (!is_null($unvan) && !is_string($unvan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unvan, true), gettype($unvan)), __LINE__);
        }
        $this->Unvan = $unvan;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get ePosta value
     * @return string|null
     */
    public function getEPosta()
    {
        return $this->ePosta;
    }
    /**
     * Set ePosta value
     * @param string $ePosta
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setEPosta($ePosta = null)
    {
        // validation for constraint: string
        if (!is_null($ePosta) && !is_string($ePosta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ePosta, true), gettype($ePosta)), __LINE__);
        }
        $this->ePosta = $ePosta;
        return $this;
    }
    /**
     * Get SinerjiB2CSchoolName value
     * @return string|null
     */
    public function getSinerjiB2CSchoolName()
    {
        return $this->SinerjiB2CSchoolName;
    }
    /**
     * Set SinerjiB2CSchoolName value
     * @param string $sinerjiB2CSchoolName
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setSinerjiB2CSchoolName($sinerjiB2CSchoolName = null)
    {
        // validation for constraint: string
        if (!is_null($sinerjiB2CSchoolName) && !is_string($sinerjiB2CSchoolName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sinerjiB2CSchoolName, true), gettype($sinerjiB2CSchoolName)), __LINE__);
        }
        $this->SinerjiB2CSchoolName = $sinerjiB2CSchoolName;
        return $this;
    }
    /**
     * Get SatisElemani value
     * @return \fk_\StructType\SatisElemaniPointer|null
     */
    public function getSatisElemani()
    {
        return $this->SatisElemani;
    }
    /**
     * Set SatisElemani value
     * @param \fk_\StructType\SatisElemaniPointer $satisElemani
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setSatisElemani(\fk_\StructType\SatisElemaniPointer $satisElemani = null)
    {
        $this->SatisElemani = $satisElemani;
        return $this;
    }
    /**
     * Get RefOzelGrup value
     * @return \fk_\StructType\GrupPointer|null
     */
    public function getRefOzelGrup()
    {
        return $this->RefOzelGrup;
    }
    /**
     * Set RefOzelGrup value
     * @param \fk_\StructType\GrupPointer $refOzelGrup
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setRefOzelGrup(\fk_\StructType\GrupPointer $refOzelGrup = null)
    {
        $this->RefOzelGrup = $refOzelGrup;
        return $this;
    }
    /**
     * Get TCNumarasi value
     * @return string|null
     */
    public function getTCNumarasi()
    {
        return $this->TCNumarasi;
    }
    /**
     * Set TCNumarasi value
     * @param string $tCNumarasi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setTCNumarasi($tCNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($tCNumarasi) && !is_string($tCNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCNumarasi, true), gettype($tCNumarasi)), __LINE__);
        }
        $this->TCNumarasi = $tCNumarasi;
        return $this;
    }
    /**
     * Get VergiDairesi value
     * @return string|null
     */
    public function getVergiDairesi()
    {
        return $this->VergiDairesi;
    }
    /**
     * Set VergiDairesi value
     * @param string $vergiDairesi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setVergiDairesi($vergiDairesi = null)
    {
        // validation for constraint: string
        if (!is_null($vergiDairesi) && !is_string($vergiDairesi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vergiDairesi, true), gettype($vergiDairesi)), __LINE__);
        }
        $this->VergiDairesi = $vergiDairesi;
        return $this;
    }
    /**
     * Get KargoCariKodu value
     * @return string|null
     */
    public function getKargoCariKodu()
    {
        return $this->KargoCariKodu;
    }
    /**
     * Set KargoCariKodu value
     * @param string $kargoCariKodu
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargoCariKodu($kargoCariKodu = null)
    {
        // validation for constraint: string
        if (!is_null($kargoCariKodu) && !is_string($kargoCariKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoCariKodu, true), gettype($kargoCariKodu)), __LINE__);
        }
        $this->KargoCariKodu = $kargoCariKodu;
        return $this;
    }
    /**
     * Get KargoSubesi value
     * @return string|null
     */
    public function getKargoSubesi()
    {
        return $this->KargoSubesi;
    }
    /**
     * Set KargoSubesi value
     * @param string $kargoSubesi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargoSubesi($kargoSubesi = null)
    {
        // validation for constraint: string
        if (!is_null($kargoSubesi) && !is_string($kargoSubesi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoSubesi, true), gettype($kargoSubesi)), __LINE__);
        }
        $this->KargoSubesi = $kargoSubesi;
        return $this;
    }
    /**
     * Get KargoAktarmasi value
     * @return string|null
     */
    public function getKargoAktarmasi()
    {
        return $this->KargoAktarmasi;
    }
    /**
     * Set KargoAktarmasi value
     * @param string $kargoAktarmasi
     * @return \fk_\StructType\CariSevkAdresi
     */
    public function setKargoAktarmasi($kargoAktarmasi = null)
    {
        // validation for constraint: string
        if (!is_null($kargoAktarmasi) && !is_string($kargoAktarmasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoAktarmasi, true), gettype($kargoAktarmasi)), __LINE__);
        }
        $this->KargoAktarmasi = $kargoAktarmasi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\CariSevkAdresi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
