<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KProje StructType
 * @subpackage Structs
 */
class KProje extends Entity
{
    /**
     * The Tur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tur;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $Sube;
    /**
     * Constructor method for KProje
     * @uses KProje::setTur()
     * @uses KProje::setKodu()
     * @uses KProje::setAdi()
     * @uses KProje::setAciklama()
     * @uses KProje::setSube()
     * @param string $tur
     * @param string $kodu
     * @param string $adi
     * @param string $aciklama
     * @param \fk_\StructType\KSubePointer $sube
     */
    public function __construct($tur = null, $kodu = null, $adi = null, $aciklama = null, \fk_\StructType\KSubePointer $sube = null)
    {
        $this
            ->setTur($tur)
            ->setKodu($kodu)
            ->setAdi($adi)
            ->setAciklama($aciklama)
            ->setSube($sube);
    }
    /**
     * Get Tur value
     * @return string
     */
    public function getTur()
    {
        return $this->Tur;
    }
    /**
     * Set Tur value
     * @uses \fk_\EnumType\ProjeTur::valueIsValid()
     * @uses \fk_\EnumType\ProjeTur::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tur
     * @return \fk_\StructType\KProje
     */
    public function setTur($tur = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\ProjeTur::valueIsValid($tur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\ProjeTur', is_array($tur) ? implode(', ', $tur) : var_export($tur, true), implode(', ', \fk_\EnumType\ProjeTur::getValidValues())), __LINE__);
        }
        $this->Tur = $tur;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \fk_\StructType\KProje
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\KProje
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KProje
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Sube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \fk_\StructType\KSubePointer $sube
     * @return \fk_\StructType\KProje
     */
    public function setSube(\fk_\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KProje
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
