<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracStatu EnumType
 * @subpackage Enumerations
 */
class KAracStatu
{
    /**
     * Constant for value 'Ticari'
     * @return string 'Ticari'
     */
    const VALUE_TICARI = 'Ticari';
    /**
     * Constant for value 'Hususi'
     * @return string 'Hususi'
     */
    const VALUE_HUSUSI = 'Hususi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TICARI
     * @uses self::VALUE_HUSUSI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TICARI,
            self::VALUE_HUSUSI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
