<?php

namespace fk_\EnumType;

/**
 * This class stands for KWebGonderiGirisiHesaplamaTuru EnumType
 * @subpackage Enumerations
 */
class KWebGonderiGirisiHesaplamaTuru
{
    /**
     * Constant for value 'Bos'
     * @return string 'Bos'
     */
    const VALUE_BOS = 'Bos';
    /**
     * Constant for value 'Sozlesmeden'
     * @return string 'Sozlesmeden'
     */
    const VALUE_SOZLESMEDEN = 'Sozlesmeden';
    /**
     * Constant for value 'Kampanyadan'
     * @return string 'Kampanyadan'
     */
    const VALUE_KAMPANYADAN = 'Kampanyadan';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOS
     * @uses self::VALUE_SOZLESMEDEN
     * @uses self::VALUE_KAMPANYADAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOS,
            self::VALUE_SOZLESMEDEN,
            self::VALUE_KAMPANYADAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
