<?php

namespace fk_\EnumType;

/**
 * This class stands for KSurucuDurum EnumType
 * @subpackage Enumerations
 */
class KSurucuDurum
{
    /**
     * Constant for value 'Subede'
     * @return string 'Subede'
     */
    const VALUE_SUBEDE = 'Subede';
    /**
     * Constant for value 'Seferde'
     * @return string 'Seferde'
     */
    const VALUE_SEFERDE = 'Seferde';
    /**
     * Constant for value 'Izinli'
     * @return string 'Izinli'
     */
    const VALUE_IZINLI = 'Izinli';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUBEDE
     * @uses self::VALUE_SEFERDE
     * @uses self::VALUE_IZINLI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUBEDE,
            self::VALUE_SEFERDE,
            self::VALUE_IZINLI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
