<?php

namespace fk_\EnumType;

/**
 * This class stands for KElemanDurum EnumType
 * @subpackage Enumerations
 */
class KElemanDurum
{
    /**
     * Constant for value 'Subede'
     * @return string 'Subede'
     */
    const VALUE_SUBEDE = 'Subede';
    /**
     * Constant for value 'KargoDagitimda'
     * @return string 'KargoDagitimda'
     */
    const VALUE_KARGO_DAGITIMDA = 'KargoDagitimda';
    /**
     * Constant for value 'AracSeferinde'
     * @return string 'AracSeferinde'
     */
    const VALUE_ARAC_SEFERINDE = 'AracSeferinde';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUBEDE
     * @uses self::VALUE_KARGO_DAGITIMDA
     * @uses self::VALUE_ARAC_SEFERINDE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUBEDE,
            self::VALUE_KARGO_DAGITIMDA,
            self::VALUE_ARAC_SEFERINDE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
