<?php

namespace fk_\EnumType;

/**
 * This class stands for KullaniciTipi EnumType
 * @subpackage Enumerations
 */
class KullaniciTipi
{
    /**
     * Constant for value 'BMT'
     * @return string 'BMT'
     */
    const VALUE_BMT = 'BMT';
    /**
     * Constant for value 'PazarlamaYoneticisi'
     * @return string 'PazarlamaYoneticisi'
     */
    const VALUE_PAZARLAMA_YONETICISI = 'PazarlamaYoneticisi';
    /**
     * Constant for value 'Yonetici'
     * @return string 'Yonetici'
     */
    const VALUE_YONETICI = 'Yonetici';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BMT
     * @uses self::VALUE_PAZARLAMA_YONETICISI
     * @uses self::VALUE_YONETICI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BMT,
            self::VALUE_PAZARLAMA_YONETICISI,
            self::VALUE_YONETICI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
