<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracMazeretDurum EnumType
 * @subpackage Enumerations
 */
class KAracMazeretDurum
{
    /**
     * Constant for value 'Gerekli'
     * @return string 'Gerekli'
     */
    const VALUE_GEREKLI = 'Gerekli';
    /**
     * Constant for value 'Girildi'
     * @return string 'Girildi'
     */
    const VALUE_GIRILDI = 'Girildi';
    /**
     * Constant for value 'Okundu'
     * @return string 'Okundu'
     */
    const VALUE_OKUNDU = 'Okundu';
    /**
     * Constant for value 'Onayli'
     * @return string 'Onayli'
     */
    const VALUE_ONAYLI = 'Onayli';
    /**
     * Constant for value 'Ret'
     * @return string 'Ret'
     */
    const VALUE_RET = 'Ret';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GEREKLI
     * @uses self::VALUE_GIRILDI
     * @uses self::VALUE_OKUNDU
     * @uses self::VALUE_ONAYLI
     * @uses self::VALUE_RET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GEREKLI,
            self::VALUE_GIRILDI,
            self::VALUE_OKUNDU,
            self::VALUE_ONAYLI,
            self::VALUE_RET,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
