<?php

namespace fk_\EnumType;

/**
 * This class stands for EArsivAdresTuru EnumType
 * @subpackage Enumerations
 */
class EArsivAdresTuru
{
    /**
     * Constant for value 'CariHesabi'
     * @return string 'CariHesabi'
     */
    const VALUE_CARI_HESABI = 'CariHesabi';
    /**
     * Constant for value 'SevkAdresi'
     * @return string 'SevkAdresi'
     */
    const VALUE_SEVK_ADRESI = 'SevkAdresi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CARI_HESABI
     * @uses self::VALUE_SEVK_ADRESI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CARI_HESABI,
            self::VALUE_SEVK_ADRESI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
