<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKargoTeslimat StructType
 * @subpackage Structs
 */
class KKargoTeslimat extends Entity
{
    /**
     * The TeslimTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TeslimTar;
    /**
     * The DogumTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DogumTar;
    /**
     * The KmlkTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KmlkTip;
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Durum;
    /**
     * The Sebep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Sebep;
    /**
     * The Mgtmi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Mgtmi;
    /**
     * The GitGelKargoKacGunSonraTeslimAlinacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GitGelKargoKacGunSonraTeslimAlinacak;
    /**
     * The Kargo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KKargoPointer
     */
    public $Kargo;
    /**
     * The Fatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $Fatura;
    /**
     * The Tesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellumPointer
     */
    public $Tesellum;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $Sube;
    /**
     * The CevapSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $CevapSube;
    /**
     * The Eleman
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KElemanPointer
     */
    public $Eleman;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The BabaAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BabaAdi;
    /**
     * The DogumYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DogumYeri;
    /**
     * The NufusKayitYer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NufusKayitYer;
    /**
     * The KimlikNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KimlikNo;
    /**
     * Constructor method for KKargoTeslimat
     * @uses KKargoTeslimat::setTeslimTar()
     * @uses KKargoTeslimat::setDogumTar()
     * @uses KKargoTeslimat::setKmlkTip()
     * @uses KKargoTeslimat::setDurum()
     * @uses KKargoTeslimat::setSebep()
     * @uses KKargoTeslimat::setMgtmi()
     * @uses KKargoTeslimat::setGitGelKargoKacGunSonraTeslimAlinacak()
     * @uses KKargoTeslimat::setKargo()
     * @uses KKargoTeslimat::setFatura()
     * @uses KKargoTeslimat::setTesellum()
     * @uses KKargoTeslimat::setSube()
     * @uses KKargoTeslimat::setCevapSube()
     * @uses KKargoTeslimat::setEleman()
     * @uses KKargoTeslimat::setAdi()
     * @uses KKargoTeslimat::setBabaAdi()
     * @uses KKargoTeslimat::setDogumYeri()
     * @uses KKargoTeslimat::setNufusKayitYer()
     * @uses KKargoTeslimat::setKimlikNo()
     * @param string $teslimTar
     * @param string $dogumTar
     * @param string $kmlkTip
     * @param string $durum
     * @param int $sebep
     * @param bool $mgtmi
     * @param int $gitGelKargoKacGunSonraTeslimAlinacak
     * @param \fk_\StructType\KKargoPointer $kargo
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @param \fk_\StructType\KSubePointer $sube
     * @param \fk_\StructType\KSubePointer $cevapSube
     * @param \fk_\StructType\KElemanPointer $eleman
     * @param string $adi
     * @param string $babaAdi
     * @param string $dogumYeri
     * @param string $nufusKayitYer
     * @param string $kimlikNo
     */
    public function __construct($teslimTar = null, $dogumTar = null, $kmlkTip = null, $durum = null, $sebep = null, $mgtmi = null, $gitGelKargoKacGunSonraTeslimAlinacak = null, \fk_\StructType\KKargoPointer $kargo = null, \fk_\StructType\KFaturaPointer $fatura = null, \fk_\StructType\KTesellumPointer $tesellum = null, \fk_\StructType\KSubePointer $sube = null, \fk_\StructType\KSubePointer $cevapSube = null, \fk_\StructType\KElemanPointer $eleman = null, $adi = null, $babaAdi = null, $dogumYeri = null, $nufusKayitYer = null, $kimlikNo = null)
    {
        $this
            ->setTeslimTar($teslimTar)
            ->setDogumTar($dogumTar)
            ->setKmlkTip($kmlkTip)
            ->setDurum($durum)
            ->setSebep($sebep)
            ->setMgtmi($mgtmi)
            ->setGitGelKargoKacGunSonraTeslimAlinacak($gitGelKargoKacGunSonraTeslimAlinacak)
            ->setKargo($kargo)
            ->setFatura($fatura)
            ->setTesellum($tesellum)
            ->setSube($sube)
            ->setCevapSube($cevapSube)
            ->setEleman($eleman)
            ->setAdi($adi)
            ->setBabaAdi($babaAdi)
            ->setDogumYeri($dogumYeri)
            ->setNufusKayitYer($nufusKayitYer)
            ->setKimlikNo($kimlikNo);
    }
    /**
     * Get TeslimTar value
     * @return string
     */
    public function getTeslimTar()
    {
        return $this->TeslimTar;
    }
    /**
     * Set TeslimTar value
     * @param string $teslimTar
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setTeslimTar($teslimTar = null)
    {
        // validation for constraint: string
        if (!is_null($teslimTar) && !is_string($teslimTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teslimTar, true), gettype($teslimTar)), __LINE__);
        }
        $this->TeslimTar = $teslimTar;
        return $this;
    }
    /**
     * Get DogumTar value
     * @return string
     */
    public function getDogumTar()
    {
        return $this->DogumTar;
    }
    /**
     * Set DogumTar value
     * @param string $dogumTar
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setDogumTar($dogumTar = null)
    {
        // validation for constraint: string
        if (!is_null($dogumTar) && !is_string($dogumTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dogumTar, true), gettype($dogumTar)), __LINE__);
        }
        $this->DogumTar = $dogumTar;
        return $this;
    }
    /**
     * Get KmlkTip value
     * @return string
     */
    public function getKmlkTip()
    {
        return $this->KmlkTip;
    }
    /**
     * Set KmlkTip value
     * @uses \fk_\EnumType\KimlikTip::valueIsValid()
     * @uses \fk_\EnumType\KimlikTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kmlkTip
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setKmlkTip($kmlkTip = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KimlikTip::valueIsValid($kmlkTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KimlikTip', is_array($kmlkTip) ? implode(', ', $kmlkTip) : var_export($kmlkTip, true), implode(', ', \fk_\EnumType\KimlikTip::getValidValues())), __LINE__);
        }
        $this->KmlkTip = $kmlkTip;
        return $this;
    }
    /**
     * Get Durum value
     * @return string
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \fk_\EnumType\KTeslimatDurum::valueIsValid()
     * @uses \fk_\EnumType\KTeslimatDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KTeslimatDurum::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KTeslimatDurum', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \fk_\EnumType\KTeslimatDurum::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get Sebep value
     * @return int
     */
    public function getSebep()
    {
        return $this->Sebep;
    }
    /**
     * Set Sebep value
     * @param int $sebep
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setSebep($sebep = null)
    {
        // validation for constraint: int
        if (!is_null($sebep) && !(is_int($sebep) || ctype_digit($sebep))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sebep, true), gettype($sebep)), __LINE__);
        }
        $this->Sebep = $sebep;
        return $this;
    }
    /**
     * Get Mgtmi value
     * @return bool
     */
    public function getMgtmi()
    {
        return $this->Mgtmi;
    }
    /**
     * Set Mgtmi value
     * @param bool $mgtmi
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setMgtmi($mgtmi = null)
    {
        // validation for constraint: boolean
        if (!is_null($mgtmi) && !is_bool($mgtmi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mgtmi, true), gettype($mgtmi)), __LINE__);
        }
        $this->Mgtmi = $mgtmi;
        return $this;
    }
    /**
     * Get GitGelKargoKacGunSonraTeslimAlinacak value
     * @return int
     */
    public function getGitGelKargoKacGunSonraTeslimAlinacak()
    {
        return $this->GitGelKargoKacGunSonraTeslimAlinacak;
    }
    /**
     * Set GitGelKargoKacGunSonraTeslimAlinacak value
     * @param int $gitGelKargoKacGunSonraTeslimAlinacak
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setGitGelKargoKacGunSonraTeslimAlinacak($gitGelKargoKacGunSonraTeslimAlinacak = null)
    {
        // validation for constraint: int
        if (!is_null($gitGelKargoKacGunSonraTeslimAlinacak) && !(is_int($gitGelKargoKacGunSonraTeslimAlinacak) || ctype_digit($gitGelKargoKacGunSonraTeslimAlinacak))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gitGelKargoKacGunSonraTeslimAlinacak, true), gettype($gitGelKargoKacGunSonraTeslimAlinacak)), __LINE__);
        }
        $this->GitGelKargoKacGunSonraTeslimAlinacak = $gitGelKargoKacGunSonraTeslimAlinacak;
        return $this;
    }
    /**
     * Get Kargo value
     * @return \fk_\StructType\KKargoPointer|null
     */
    public function getKargo()
    {
        return $this->Kargo;
    }
    /**
     * Set Kargo value
     * @param \fk_\StructType\KKargoPointer $kargo
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setKargo(\fk_\StructType\KKargoPointer $kargo = null)
    {
        $this->Kargo = $kargo;
        return $this;
    }
    /**
     * Get Fatura value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getFatura()
    {
        return $this->Fatura;
    }
    /**
     * Set Fatura value
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setFatura(\fk_\StructType\KFaturaPointer $fatura = null)
    {
        $this->Fatura = $fatura;
        return $this;
    }
    /**
     * Get Tesellum value
     * @return \fk_\StructType\KTesellumPointer|null
     */
    public function getTesellum()
    {
        return $this->Tesellum;
    }
    /**
     * Set Tesellum value
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setTesellum(\fk_\StructType\KTesellumPointer $tesellum = null)
    {
        $this->Tesellum = $tesellum;
        return $this;
    }
    /**
     * Get Sube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \fk_\StructType\KSubePointer $sube
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setSube(\fk_\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get CevapSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getCevapSube()
    {
        return $this->CevapSube;
    }
    /**
     * Set CevapSube value
     * @param \fk_\StructType\KSubePointer $cevapSube
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setCevapSube(\fk_\StructType\KSubePointer $cevapSube = null)
    {
        $this->CevapSube = $cevapSube;
        return $this;
    }
    /**
     * Get Eleman value
     * @return \fk_\StructType\KElemanPointer|null
     */
    public function getEleman()
    {
        return $this->Eleman;
    }
    /**
     * Set Eleman value
     * @param \fk_\StructType\KElemanPointer $eleman
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setEleman(\fk_\StructType\KElemanPointer $eleman = null)
    {
        $this->Eleman = $eleman;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get BabaAdi value
     * @return string|null
     */
    public function getBabaAdi()
    {
        return $this->BabaAdi;
    }
    /**
     * Set BabaAdi value
     * @param string $babaAdi
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setBabaAdi($babaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($babaAdi) && !is_string($babaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($babaAdi, true), gettype($babaAdi)), __LINE__);
        }
        $this->BabaAdi = $babaAdi;
        return $this;
    }
    /**
     * Get DogumYeri value
     * @return string|null
     */
    public function getDogumYeri()
    {
        return $this->DogumYeri;
    }
    /**
     * Set DogumYeri value
     * @param string $dogumYeri
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setDogumYeri($dogumYeri = null)
    {
        // validation for constraint: string
        if (!is_null($dogumYeri) && !is_string($dogumYeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dogumYeri, true), gettype($dogumYeri)), __LINE__);
        }
        $this->DogumYeri = $dogumYeri;
        return $this;
    }
    /**
     * Get NufusKayitYer value
     * @return string|null
     */
    public function getNufusKayitYer()
    {
        return $this->NufusKayitYer;
    }
    /**
     * Set NufusKayitYer value
     * @param string $nufusKayitYer
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setNufusKayitYer($nufusKayitYer = null)
    {
        // validation for constraint: string
        if (!is_null($nufusKayitYer) && !is_string($nufusKayitYer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nufusKayitYer, true), gettype($nufusKayitYer)), __LINE__);
        }
        $this->NufusKayitYer = $nufusKayitYer;
        return $this;
    }
    /**
     * Get KimlikNo value
     * @return string|null
     */
    public function getKimlikNo()
    {
        return $this->KimlikNo;
    }
    /**
     * Set KimlikNo value
     * @param string $kimlikNo
     * @return \fk_\StructType\KKargoTeslimat
     */
    public function setKimlikNo($kimlikNo = null)
    {
        // validation for constraint: string
        if (!is_null($kimlikNo) && !is_string($kimlikNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kimlikNo, true), gettype($kimlikNo)), __LINE__);
        }
        $this->KimlikNo = $kimlikNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KKargoTeslimat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
