<?php

namespace fk_\EnumType;

/**
 * This class stands for KWebGonderininGelisSekli EnumType
 * @subpackage Enumerations
 */
class KWebGonderininGelisSekli
{
    /**
     * Constant for value 'SelfService'
     * @return string 'SelfService'
     */
    const VALUE_SELF_SERVICE = 'SelfService';
    /**
     * Constant for value 'WebServiceGrupDisi'
     * @return string 'WebServiceGrupDisi'
     */
    const VALUE_WEB_SERVICE_GRUP_DISI = 'WebServiceGrupDisi';
    /**
     * Constant for value 'WebServiceGrupIci'
     * @return string 'WebServiceGrupIci'
     */
    const VALUE_WEB_SERVICE_GRUP_ICI = 'WebServiceGrupIci';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELF_SERVICE
     * @uses self::VALUE_WEB_SERVICE_GRUP_DISI
     * @uses self::VALUE_WEB_SERVICE_GRUP_ICI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELF_SERVICE,
            self::VALUE_WEB_SERVICE_GRUP_DISI,
            self::VALUE_WEB_SERVICE_GRUP_ICI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
