<?php

namespace fk_\EnumType;

/**
 * This class stands for CariHesapDurum EnumType
 * @subpackage Enumerations
 */
class CariHesapDurum
{
    /**
     * Constant for value 'Potansiyel'
     * @return string 'Potansiyel'
     */
    const VALUE_POTANSIYEL = 'Potansiyel';
    /**
     * Constant for value 'Aktif'
     * @return string 'Aktif'
     */
    const VALUE_AKTIF = 'Aktif';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_POTANSIYEL
     * @uses self::VALUE_AKTIF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_POTANSIYEL,
            self::VALUE_AKTIF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
