<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KMusteriEntegrasyon StructType
 * @subpackage Structs
 */
class KMusteriEntegrasyon extends Entity
{
    /**
     * The MusteriKapidaTahsilatTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MusteriKapidaTahsilatTutari;
    /**
     * The MusteriEntegrasyon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MusteriEntegrasyon;
    /**
     * The WhopPays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhopPays;
    /**
     * The MusteriCariId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariId;
    /**
     * The MusteriCariAdresiId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariAdresiId;
    /**
     * The SerendipCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $SerendipCari;
    /**
     * The SerendipCariAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAdresPointer
     */
    public $SerendipCariAdresi;
    /**
     * The MusteriCariAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariAdi;
    /**
     * The MusteriCariSoyadi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariSoyadi;
    /**
     * The MusteriCariAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariAdresi;
    /**
     * The MusteriCariIl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariIl;
    /**
     * The MusteriCariBolgesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariBolgesi;
    /**
     * The MusteriCariPostaKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariPostaKodu;
    /**
     * The MusteriCariTelefonNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariTelefonNo;
    /**
     * The MusteriCariKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriCariKodu;
    /**
     * Constructor method for KMusteriEntegrasyon
     * @uses KMusteriEntegrasyon::setMusteriKapidaTahsilatTutari()
     * @uses KMusteriEntegrasyon::setMusteriEntegrasyon()
     * @uses KMusteriEntegrasyon::setWhopPays()
     * @uses KMusteriEntegrasyon::setMusteriCariId()
     * @uses KMusteriEntegrasyon::setMusteriCariAdresiId()
     * @uses KMusteriEntegrasyon::setSerendipCari()
     * @uses KMusteriEntegrasyon::setSerendipCariAdresi()
     * @uses KMusteriEntegrasyon::setMusteriCariAdi()
     * @uses KMusteriEntegrasyon::setMusteriCariSoyadi()
     * @uses KMusteriEntegrasyon::setMusteriCariAdresi()
     * @uses KMusteriEntegrasyon::setMusteriCariIl()
     * @uses KMusteriEntegrasyon::setMusteriCariBolgesi()
     * @uses KMusteriEntegrasyon::setMusteriCariPostaKodu()
     * @uses KMusteriEntegrasyon::setMusteriCariTelefonNo()
     * @uses KMusteriEntegrasyon::setMusteriCariKodu()
     * @param float $musteriKapidaTahsilatTutari
     * @param string $musteriEntegrasyon
     * @param string $whopPays
     * @param string $musteriCariId
     * @param string $musteriCariAdresiId
     * @param \fk_\StructType\KCariPointer $serendipCari
     * @param \fk_\StructType\KAdresPointer $serendipCariAdresi
     * @param string $musteriCariAdi
     * @param string $musteriCariSoyadi
     * @param string $musteriCariAdresi
     * @param string $musteriCariIl
     * @param string $musteriCariBolgesi
     * @param string $musteriCariPostaKodu
     * @param string $musteriCariTelefonNo
     * @param string $musteriCariKodu
     */
    public function __construct($musteriKapidaTahsilatTutari = null, $musteriEntegrasyon = null, $whopPays = null, $musteriCariId = null, $musteriCariAdresiId = null, \fk_\StructType\KCariPointer $serendipCari = null, \fk_\StructType\KAdresPointer $serendipCariAdresi = null, $musteriCariAdi = null, $musteriCariSoyadi = null, $musteriCariAdresi = null, $musteriCariIl = null, $musteriCariBolgesi = null, $musteriCariPostaKodu = null, $musteriCariTelefonNo = null, $musteriCariKodu = null)
    {
        $this
            ->setMusteriKapidaTahsilatTutari($musteriKapidaTahsilatTutari)
            ->setMusteriEntegrasyon($musteriEntegrasyon)
            ->setWhopPays($whopPays)
            ->setMusteriCariId($musteriCariId)
            ->setMusteriCariAdresiId($musteriCariAdresiId)
            ->setSerendipCari($serendipCari)
            ->setSerendipCariAdresi($serendipCariAdresi)
            ->setMusteriCariAdi($musteriCariAdi)
            ->setMusteriCariSoyadi($musteriCariSoyadi)
            ->setMusteriCariAdresi($musteriCariAdresi)
            ->setMusteriCariIl($musteriCariIl)
            ->setMusteriCariBolgesi($musteriCariBolgesi)
            ->setMusteriCariPostaKodu($musteriCariPostaKodu)
            ->setMusteriCariTelefonNo($musteriCariTelefonNo)
            ->setMusteriCariKodu($musteriCariKodu);
    }
    /**
     * Get MusteriKapidaTahsilatTutari value
     * @return float
     */
    public function getMusteriKapidaTahsilatTutari()
    {
        return $this->MusteriKapidaTahsilatTutari;
    }
    /**
     * Set MusteriKapidaTahsilatTutari value
     * @param float $musteriKapidaTahsilatTutari
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriKapidaTahsilatTutari($musteriKapidaTahsilatTutari = null)
    {
        // validation for constraint: float
        if (!is_null($musteriKapidaTahsilatTutari) && !(is_float($musteriKapidaTahsilatTutari) || is_numeric($musteriKapidaTahsilatTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($musteriKapidaTahsilatTutari, true), gettype($musteriKapidaTahsilatTutari)), __LINE__);
        }
        $this->MusteriKapidaTahsilatTutari = $musteriKapidaTahsilatTutari;
        return $this;
    }
    /**
     * Get MusteriEntegrasyon value
     * @return string
     */
    public function getMusteriEntegrasyon()
    {
        return $this->MusteriEntegrasyon;
    }
    /**
     * Set MusteriEntegrasyon value
     * @uses \fk_\EnumType\MusteriEntegrasyon::valueIsValid()
     * @uses \fk_\EnumType\MusteriEntegrasyon::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $musteriEntegrasyon
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriEntegrasyon($musteriEntegrasyon = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\MusteriEntegrasyon::valueIsValid($musteriEntegrasyon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\MusteriEntegrasyon', is_array($musteriEntegrasyon) ? implode(', ', $musteriEntegrasyon) : var_export($musteriEntegrasyon, true), implode(', ', \fk_\EnumType\MusteriEntegrasyon::getValidValues())), __LINE__);
        }
        $this->MusteriEntegrasyon = $musteriEntegrasyon;
        return $this;
    }
    /**
     * Get WhopPays value
     * @return string|null
     */
    public function getWhopPays()
    {
        return $this->WhopPays;
    }
    /**
     * Set WhopPays value
     * @param string $whopPays
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setWhopPays($whopPays = null)
    {
        // validation for constraint: string
        if (!is_null($whopPays) && !is_string($whopPays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whopPays, true), gettype($whopPays)), __LINE__);
        }
        $this->WhopPays = $whopPays;
        return $this;
    }
    /**
     * Get MusteriCariId value
     * @return string|null
     */
    public function getMusteriCariId()
    {
        return $this->MusteriCariId;
    }
    /**
     * Set MusteriCariId value
     * @param string $musteriCariId
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariId($musteriCariId = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariId) && !is_string($musteriCariId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariId, true), gettype($musteriCariId)), __LINE__);
        }
        $this->MusteriCariId = $musteriCariId;
        return $this;
    }
    /**
     * Get MusteriCariAdresiId value
     * @return string|null
     */
    public function getMusteriCariAdresiId()
    {
        return $this->MusteriCariAdresiId;
    }
    /**
     * Set MusteriCariAdresiId value
     * @param string $musteriCariAdresiId
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariAdresiId($musteriCariAdresiId = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariAdresiId) && !is_string($musteriCariAdresiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariAdresiId, true), gettype($musteriCariAdresiId)), __LINE__);
        }
        $this->MusteriCariAdresiId = $musteriCariAdresiId;
        return $this;
    }
    /**
     * Get SerendipCari value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getSerendipCari()
    {
        return $this->SerendipCari;
    }
    /**
     * Set SerendipCari value
     * @param \fk_\StructType\KCariPointer $serendipCari
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setSerendipCari(\fk_\StructType\KCariPointer $serendipCari = null)
    {
        $this->SerendipCari = $serendipCari;
        return $this;
    }
    /**
     * Get SerendipCariAdresi value
     * @return \fk_\StructType\KAdresPointer|null
     */
    public function getSerendipCariAdresi()
    {
        return $this->SerendipCariAdresi;
    }
    /**
     * Set SerendipCariAdresi value
     * @param \fk_\StructType\KAdresPointer $serendipCariAdresi
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setSerendipCariAdresi(\fk_\StructType\KAdresPointer $serendipCariAdresi = null)
    {
        $this->SerendipCariAdresi = $serendipCariAdresi;
        return $this;
    }
    /**
     * Get MusteriCariAdi value
     * @return string|null
     */
    public function getMusteriCariAdi()
    {
        return $this->MusteriCariAdi;
    }
    /**
     * Set MusteriCariAdi value
     * @param string $musteriCariAdi
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariAdi($musteriCariAdi = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariAdi) && !is_string($musteriCariAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariAdi, true), gettype($musteriCariAdi)), __LINE__);
        }
        $this->MusteriCariAdi = $musteriCariAdi;
        return $this;
    }
    /**
     * Get MusteriCariSoyadi value
     * @return string|null
     */
    public function getMusteriCariSoyadi()
    {
        return $this->MusteriCariSoyadi;
    }
    /**
     * Set MusteriCariSoyadi value
     * @param string $musteriCariSoyadi
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariSoyadi($musteriCariSoyadi = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariSoyadi) && !is_string($musteriCariSoyadi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariSoyadi, true), gettype($musteriCariSoyadi)), __LINE__);
        }
        $this->MusteriCariSoyadi = $musteriCariSoyadi;
        return $this;
    }
    /**
     * Get MusteriCariAdresi value
     * @return string|null
     */
    public function getMusteriCariAdresi()
    {
        return $this->MusteriCariAdresi;
    }
    /**
     * Set MusteriCariAdresi value
     * @param string $musteriCariAdresi
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariAdresi($musteriCariAdresi = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariAdresi) && !is_string($musteriCariAdresi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariAdresi, true), gettype($musteriCariAdresi)), __LINE__);
        }
        $this->MusteriCariAdresi = $musteriCariAdresi;
        return $this;
    }
    /**
     * Get MusteriCariIl value
     * @return string|null
     */
    public function getMusteriCariIl()
    {
        return $this->MusteriCariIl;
    }
    /**
     * Set MusteriCariIl value
     * @param string $musteriCariIl
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariIl($musteriCariIl = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariIl) && !is_string($musteriCariIl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariIl, true), gettype($musteriCariIl)), __LINE__);
        }
        $this->MusteriCariIl = $musteriCariIl;
        return $this;
    }
    /**
     * Get MusteriCariBolgesi value
     * @return string|null
     */
    public function getMusteriCariBolgesi()
    {
        return $this->MusteriCariBolgesi;
    }
    /**
     * Set MusteriCariBolgesi value
     * @param string $musteriCariBolgesi
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariBolgesi($musteriCariBolgesi = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariBolgesi) && !is_string($musteriCariBolgesi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariBolgesi, true), gettype($musteriCariBolgesi)), __LINE__);
        }
        $this->MusteriCariBolgesi = $musteriCariBolgesi;
        return $this;
    }
    /**
     * Get MusteriCariPostaKodu value
     * @return string|null
     */
    public function getMusteriCariPostaKodu()
    {
        return $this->MusteriCariPostaKodu;
    }
    /**
     * Set MusteriCariPostaKodu value
     * @param string $musteriCariPostaKodu
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariPostaKodu($musteriCariPostaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariPostaKodu) && !is_string($musteriCariPostaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariPostaKodu, true), gettype($musteriCariPostaKodu)), __LINE__);
        }
        $this->MusteriCariPostaKodu = $musteriCariPostaKodu;
        return $this;
    }
    /**
     * Get MusteriCariTelefonNo value
     * @return string|null
     */
    public function getMusteriCariTelefonNo()
    {
        return $this->MusteriCariTelefonNo;
    }
    /**
     * Set MusteriCariTelefonNo value
     * @param string $musteriCariTelefonNo
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariTelefonNo($musteriCariTelefonNo = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariTelefonNo) && !is_string($musteriCariTelefonNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariTelefonNo, true), gettype($musteriCariTelefonNo)), __LINE__);
        }
        $this->MusteriCariTelefonNo = $musteriCariTelefonNo;
        return $this;
    }
    /**
     * Get MusteriCariKodu value
     * @return string|null
     */
    public function getMusteriCariKodu()
    {
        return $this->MusteriCariKodu;
    }
    /**
     * Set MusteriCariKodu value
     * @param string $musteriCariKodu
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public function setMusteriCariKodu($musteriCariKodu = null)
    {
        // validation for constraint: string
        if (!is_null($musteriCariKodu) && !is_string($musteriCariKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriCariKodu, true), gettype($musteriCariKodu)), __LINE__);
        }
        $this->MusteriCariKodu = $musteriCariKodu;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KMusteriEntegrasyon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
