<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KHizmet StructType
 * @subpackage Structs
 */
class KHizmet extends Tanim
{
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Turu;
    /**
     * The Tipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipi;
    /**
     * The SP_HizmetObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_HizmetObjId;
    /**
     * The SP_HizmetMuhasebeHesapSablonObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_HizmetMuhasebeHesapSablonObjId;
    /**
     * The KDVOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KDVOran;
    /**
     * Constructor method for KHizmet
     * @uses KHizmet::setTuru()
     * @uses KHizmet::setTipi()
     * @uses KHizmet::setSP_HizmetObjId()
     * @uses KHizmet::setSP_HizmetMuhasebeHesapSablonObjId()
     * @uses KHizmet::setKDVOran()
     * @param string $turu
     * @param string $tipi
     * @param int $sP_HizmetObjId
     * @param int $sP_HizmetMuhasebeHesapSablonObjId
     * @param float $kDVOran
     */
    public function __construct($turu = null, $tipi = null, $sP_HizmetObjId = null, $sP_HizmetMuhasebeHesapSablonObjId = null, $kDVOran = null)
    {
        $this
            ->setTuru($turu)
            ->setTipi($tipi)
            ->setSP_HizmetObjId($sP_HizmetObjId)
            ->setSP_HizmetMuhasebeHesapSablonObjId($sP_HizmetMuhasebeHesapSablonObjId)
            ->setKDVOran($kDVOran);
    }
    /**
     * Get Turu value
     * @return string
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @uses \fk_\EnumType\HizmetHesapTipi::valueIsValid()
     * @uses \fk_\EnumType\HizmetHesapTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $turu
     * @return \fk_\StructType\KHizmet
     */
    public function setTuru($turu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\HizmetHesapTipi::valueIsValid($turu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\HizmetHesapTipi', is_array($turu) ? implode(', ', $turu) : var_export($turu, true), implode(', ', \fk_\EnumType\HizmetHesapTipi::getValidValues())), __LINE__);
        }
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get Tipi value
     * @return string
     */
    public function getTipi()
    {
        return $this->Tipi;
    }
    /**
     * Set Tipi value
     * @uses \fk_\EnumType\HizmetTipi::valueIsValid()
     * @uses \fk_\EnumType\HizmetTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipi
     * @return \fk_\StructType\KHizmet
     */
    public function setTipi($tipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\HizmetTipi::valueIsValid($tipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\HizmetTipi', is_array($tipi) ? implode(', ', $tipi) : var_export($tipi, true), implode(', ', \fk_\EnumType\HizmetTipi::getValidValues())), __LINE__);
        }
        $this->Tipi = $tipi;
        return $this;
    }
    /**
     * Get SP_HizmetObjId value
     * @return int
     */
    public function getSP_HizmetObjId()
    {
        return $this->SP_HizmetObjId;
    }
    /**
     * Set SP_HizmetObjId value
     * @param int $sP_HizmetObjId
     * @return \fk_\StructType\KHizmet
     */
    public function setSP_HizmetObjId($sP_HizmetObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_HizmetObjId) && !(is_int($sP_HizmetObjId) || ctype_digit($sP_HizmetObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_HizmetObjId, true), gettype($sP_HizmetObjId)), __LINE__);
        }
        $this->SP_HizmetObjId = $sP_HizmetObjId;
        return $this;
    }
    /**
     * Get SP_HizmetMuhasebeHesapSablonObjId value
     * @return int
     */
    public function getSP_HizmetMuhasebeHesapSablonObjId()
    {
        return $this->SP_HizmetMuhasebeHesapSablonObjId;
    }
    /**
     * Set SP_HizmetMuhasebeHesapSablonObjId value
     * @param int $sP_HizmetMuhasebeHesapSablonObjId
     * @return \fk_\StructType\KHizmet
     */
    public function setSP_HizmetMuhasebeHesapSablonObjId($sP_HizmetMuhasebeHesapSablonObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_HizmetMuhasebeHesapSablonObjId) && !(is_int($sP_HizmetMuhasebeHesapSablonObjId) || ctype_digit($sP_HizmetMuhasebeHesapSablonObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_HizmetMuhasebeHesapSablonObjId, true), gettype($sP_HizmetMuhasebeHesapSablonObjId)), __LINE__);
        }
        $this->SP_HizmetMuhasebeHesapSablonObjId = $sP_HizmetMuhasebeHesapSablonObjId;
        return $this;
    }
    /**
     * Get KDVOran value
     * @return float
     */
    public function getKDVOran()
    {
        return $this->KDVOran;
    }
    /**
     * Set KDVOran value
     * @param float $kDVOran
     * @return \fk_\StructType\KHizmet
     */
    public function setKDVOran($kDVOran = null)
    {
        // validation for constraint: float
        if (!is_null($kDVOran) && !(is_float($kDVOran) || is_numeric($kDVOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kDVOran, true), gettype($kDVOran)), __LINE__);
        }
        $this->KDVOran = $kDVOran;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KHizmet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
