<?php

namespace fk_\EnumType;

/**
 * This class stands for KGonderimSekli EnumType
 * @subpackage Enumerations
 */
class KGonderimSekli
{
    /**
     * Constant for value 'Ekonomi'
     * @return string 'Ekonomi'
     */
    const VALUE_EKONOMI = 'Ekonomi';
    /**
     * Constant for value 'Ekspress'
     * @return string 'Ekspress'
     */
    const VALUE_EKSPRESS = 'Ekspress';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EKONOMI
     * @uses self::VALUE_EKSPRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EKONOMI,
            self::VALUE_EKSPRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
