<?php

namespace fk_\EnumType;

/**
 * This class stands for KargoEvetHayirSeciniz EnumType
 * @subpackage Enumerations
 */
class KargoEvetHayirSeciniz
{
    /**
     * Constant for value 'Seçiniz'
     * @return string 'Seçiniz'
     */
    const VALUE_SE_ÇINIZ = 'Seçiniz';
    /**
     * Constant for value 'Evet'
     * @return string 'Evet'
     */
    const VALUE_EVET = 'Evet';
    /**
     * Constant for value 'Hayir'
     * @return string 'Hayir'
     */
    const VALUE_HAYIR = 'Hayir';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SE_ÇINIZ
     * @uses self::VALUE_EVET
     * @uses self::VALUE_HAYIR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SE_ÇINIZ,
            self::VALUE_EVET,
            self::VALUE_HAYIR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
