<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MLYPersonelFaaliyetSatiri StructType
 * @subpackage Structs
 */
class MLYPersonelFaaliyetSatiri extends MaliyetBaseEntity
{
    /**
     * The Entity_ObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Entity_ObjId;
    /**
     * The CalismaOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CalismaOrani;
    /**
     * The FaaliyetNoktasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FaaliyetNoktasi;
    /**
     * The AnaFaaliyetGrubuObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnaFaaliyetGrubuObjId;
    /**
     * The MLYPersonelFaaliyet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\MLYPersonelFaaliyetPointer
     */
    public $MLYPersonelFaaliyet;
    /**
     * The MLYAnaFaaliyetGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\MLYAnaFaaliyetGrubu
     */
    public $MLYAnaFaaliyetGrubu;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * Constructor method for MLYPersonelFaaliyetSatiri
     * @uses MLYPersonelFaaliyetSatiri::setEntity_ObjId()
     * @uses MLYPersonelFaaliyetSatiri::setCalismaOrani()
     * @uses MLYPersonelFaaliyetSatiri::setFaaliyetNoktasi()
     * @uses MLYPersonelFaaliyetSatiri::setAnaFaaliyetGrubuObjId()
     * @uses MLYPersonelFaaliyetSatiri::setMLYPersonelFaaliyet()
     * @uses MLYPersonelFaaliyetSatiri::setMLYAnaFaaliyetGrubu()
     * @uses MLYPersonelFaaliyetSatiri::setEntityName()
     * @param int $entity_ObjId
     * @param float $calismaOrani
     * @param string $faaliyetNoktasi
     * @param int $anaFaaliyetGrubuObjId
     * @param \fk_\StructType\MLYPersonelFaaliyetPointer $mLYPersonelFaaliyet
     * @param \fk_\StructType\MLYAnaFaaliyetGrubu $mLYAnaFaaliyetGrubu
     * @param string $entityName
     */
    public function __construct($entity_ObjId = null, $calismaOrani = null, $faaliyetNoktasi = null, $anaFaaliyetGrubuObjId = null, \fk_\StructType\MLYPersonelFaaliyetPointer $mLYPersonelFaaliyet = null, \fk_\StructType\MLYAnaFaaliyetGrubu $mLYAnaFaaliyetGrubu = null, $entityName = null)
    {
        $this
            ->setEntity_ObjId($entity_ObjId)
            ->setCalismaOrani($calismaOrani)
            ->setFaaliyetNoktasi($faaliyetNoktasi)
            ->setAnaFaaliyetGrubuObjId($anaFaaliyetGrubuObjId)
            ->setMLYPersonelFaaliyet($mLYPersonelFaaliyet)
            ->setMLYAnaFaaliyetGrubu($mLYAnaFaaliyetGrubu)
            ->setEntityName($entityName);
    }
    /**
     * Get Entity_ObjId value
     * @return int
     */
    public function getEntity_ObjId()
    {
        return $this->Entity_ObjId;
    }
    /**
     * Set Entity_ObjId value
     * @param int $entity_ObjId
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setEntity_ObjId($entity_ObjId = null)
    {
        // validation for constraint: int
        if (!is_null($entity_ObjId) && !(is_int($entity_ObjId) || ctype_digit($entity_ObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entity_ObjId, true), gettype($entity_ObjId)), __LINE__);
        }
        $this->Entity_ObjId = $entity_ObjId;
        return $this;
    }
    /**
     * Get CalismaOrani value
     * @return float
     */
    public function getCalismaOrani()
    {
        return $this->CalismaOrani;
    }
    /**
     * Set CalismaOrani value
     * @param float $calismaOrani
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setCalismaOrani($calismaOrani = null)
    {
        // validation for constraint: float
        if (!is_null($calismaOrani) && !(is_float($calismaOrani) || is_numeric($calismaOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calismaOrani, true), gettype($calismaOrani)), __LINE__);
        }
        $this->CalismaOrani = $calismaOrani;
        return $this;
    }
    /**
     * Get FaaliyetNoktasi value
     * @return string
     */
    public function getFaaliyetNoktasi()
    {
        return $this->FaaliyetNoktasi;
    }
    /**
     * Set FaaliyetNoktasi value
     * @uses \fk_\EnumType\FaaliyetNoktasi::valueIsValid()
     * @uses \fk_\EnumType\FaaliyetNoktasi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $faaliyetNoktasi
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setFaaliyetNoktasi($faaliyetNoktasi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\FaaliyetNoktasi::valueIsValid($faaliyetNoktasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\FaaliyetNoktasi', is_array($faaliyetNoktasi) ? implode(', ', $faaliyetNoktasi) : var_export($faaliyetNoktasi, true), implode(', ', \fk_\EnumType\FaaliyetNoktasi::getValidValues())), __LINE__);
        }
        $this->FaaliyetNoktasi = $faaliyetNoktasi;
        return $this;
    }
    /**
     * Get AnaFaaliyetGrubuObjId value
     * @return int
     */
    public function getAnaFaaliyetGrubuObjId()
    {
        return $this->AnaFaaliyetGrubuObjId;
    }
    /**
     * Set AnaFaaliyetGrubuObjId value
     * @param int $anaFaaliyetGrubuObjId
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setAnaFaaliyetGrubuObjId($anaFaaliyetGrubuObjId = null)
    {
        // validation for constraint: int
        if (!is_null($anaFaaliyetGrubuObjId) && !(is_int($anaFaaliyetGrubuObjId) || ctype_digit($anaFaaliyetGrubuObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anaFaaliyetGrubuObjId, true), gettype($anaFaaliyetGrubuObjId)), __LINE__);
        }
        $this->AnaFaaliyetGrubuObjId = $anaFaaliyetGrubuObjId;
        return $this;
    }
    /**
     * Get MLYPersonelFaaliyet value
     * @return \fk_\StructType\MLYPersonelFaaliyetPointer|null
     */
    public function getMLYPersonelFaaliyet()
    {
        return $this->MLYPersonelFaaliyet;
    }
    /**
     * Set MLYPersonelFaaliyet value
     * @param \fk_\StructType\MLYPersonelFaaliyetPointer $mLYPersonelFaaliyet
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setMLYPersonelFaaliyet(\fk_\StructType\MLYPersonelFaaliyetPointer $mLYPersonelFaaliyet = null)
    {
        $this->MLYPersonelFaaliyet = $mLYPersonelFaaliyet;
        return $this;
    }
    /**
     * Get MLYAnaFaaliyetGrubu value
     * @return \fk_\StructType\MLYAnaFaaliyetGrubu|null
     */
    public function getMLYAnaFaaliyetGrubu()
    {
        return $this->MLYAnaFaaliyetGrubu;
    }
    /**
     * Set MLYAnaFaaliyetGrubu value
     * @param \fk_\StructType\MLYAnaFaaliyetGrubu $mLYAnaFaaliyetGrubu
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setMLYAnaFaaliyetGrubu(\fk_\StructType\MLYAnaFaaliyetGrubu $mLYAnaFaaliyetGrubu = null)
    {
        $this->MLYAnaFaaliyetGrubu = $mLYAnaFaaliyetGrubu;
        return $this;
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\MLYPersonelFaaliyetSatiri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
