<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracKasaTip EnumType
 * @subpackage Enumerations
 */
class KAracKasaTip
{
    /**
     * Constant for value 'KapaliSacKasa'
     * @return string 'KapaliSacKasa'
     */
    const VALUE_KAPALI_SAC_KASA = 'KapaliSacKasa';
    /**
     * Constant for value 'PanelVan'
     * @return string 'PanelVan'
     */
    const VALUE_PANEL_VAN = 'PanelVan';
    /**
     * Constant for value 'Tenteli'
     * @return string 'Tenteli'
     */
    const VALUE_TENTELI = 'Tenteli';
    /**
     * Constant for value 'CityVan'
     * @return string 'CityVan'
     */
    const VALUE_CITY_VAN = 'CityVan';
    /**
     * Constant for value 'KoltukluMinibus'
     * @return string 'KoltukluMinibus'
     */
    const VALUE_KOLTUKLU_MINIBUS = 'KoltukluMinibus';
    /**
     * Constant for value 'KapaliKasaKamyonet'
     * @return string 'KapaliKasaKamyonet'
     */
    const VALUE_KAPALI_KASA_KAMYONET = 'KapaliKasaKamyonet';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KAPALI_SAC_KASA
     * @uses self::VALUE_PANEL_VAN
     * @uses self::VALUE_TENTELI
     * @uses self::VALUE_CITY_VAN
     * @uses self::VALUE_KOLTUKLU_MINIBUS
     * @uses self::VALUE_KAPALI_KASA_KAMYONET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAPALI_SAC_KASA,
            self::VALUE_PANEL_VAN,
            self::VALUE_TENTELI,
            self::VALUE_CITY_VAN,
            self::VALUE_KOLTUKLU_MINIBUS,
            self::VALUE_KAPALI_KASA_KAMYONET,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
