<?php

namespace fk_\EnumType;

/**
 * This class stands for KWebCarininGelisSekli EnumType
 * @subpackage Enumerations
 */
class KWebCarininGelisSekli
{
    /**
     * Constant for value 'SelfService'
     * @return string 'SelfService'
     */
    const VALUE_SELF_SERVICE = 'SelfService';
    /**
     * Constant for value 'WebSitesinden'
     * @return string 'WebSitesinden'
     */
    const VALUE_WEB_SITESINDEN = 'WebSitesinden';
    /**
     * Constant for value 'CariEslemeEkranindan'
     * @return string 'CariEslemeEkranindan'
     */
    const VALUE_CARI_ESLEME_EKRANINDAN = 'CariEslemeEkranindan';
    /**
     * Constant for value 'TopluIslemDosyaAktarimi'
     * @return string 'TopluIslemDosyaAktarimi'
     */
    const VALUE_TOPLU_ISLEM_DOSYA_AKTARIMI = 'TopluIslemDosyaAktarimi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELF_SERVICE
     * @uses self::VALUE_WEB_SITESINDEN
     * @uses self::VALUE_CARI_ESLEME_EKRANINDAN
     * @uses self::VALUE_TOPLU_ISLEM_DOSYA_AKTARIMI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELF_SERVICE,
            self::VALUE_WEB_SITESINDEN,
            self::VALUE_CARI_ESLEME_EKRANINDAN,
            self::VALUE_TOPLU_ISLEM_DOSYA_AKTARIMI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
