<?php

namespace fk_\EnumType;

/**
 * This class stands for KOdemeTipi EnumType
 * @subpackage Enumerations
 */
class KOdemeTipi
{
    /**
     * Constant for value 'Nakit'
     * @return string 'Nakit'
     */
    const VALUE_NAKIT = 'Nakit';
    /**
     * Constant for value 'Çek'
     * @return string 'Çek'
     */
    const VALUE_ÇEK = 'Çek';
    /**
     * Constant for value 'BankaHavalesi'
     * @return string 'BankaHavalesi'
     */
    const VALUE_BANKA_HAVALESI = 'BankaHavalesi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NAKIT
     * @uses self::VALUE_ÇEK
     * @uses self::VALUE_BANKA_HAVALESI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NAKIT,
            self::VALUE_ÇEK,
            self::VALUE_BANKA_HAVALESI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
