<?php

namespace fk_\EnumType;

/**
 * This class stands for KFaturaOdemeSekli EnumType
 * @subpackage Enumerations
 */
class KFaturaOdemeSekli
{
    /**
     * Constant for value 'PesinOdeme'
     * @return string 'PesinOdeme'
     */
    const VALUE_PESIN_ODEME = 'PesinOdeme';
    /**
     * Constant for value 'PesinOdemeCariHesaptan'
     * @return string 'PesinOdemeCariHesaptan'
     */
    const VALUE_PESIN_ODEME_CARI_HESAPTAN = 'PesinOdemeCariHesaptan';
    /**
     * Constant for value 'UcretAlici'
     * @return string 'UcretAlici'
     */
    const VALUE_UCRET_ALICI = 'UcretAlici';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PESIN_ODEME
     * @uses self::VALUE_PESIN_ODEME_CARI_HESAPTAN
     * @uses self::VALUE_UCRET_ALICI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PESIN_ODEME,
            self::VALUE_PESIN_ODEME_CARI_HESAPTAN,
            self::VALUE_UCRET_ALICI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
