<?php

namespace fk_\EnumType;

/**
 * This class stands for AracOtomatikGecisTip EnumType
 * @subpackage Enumerations
 */
class AracOtomatikGecisTip
{
    /**
     * Constant for value 'OGS'
     * @return string 'OGS'
     */
    const VALUE_OGS = 'OGS';
    /**
     * Constant for value 'HGS'
     * @return string 'HGS'
     */
    const VALUE_HGS = 'HGS';
    /**
     * Constant for value 'Nakit'
     * @return string 'Nakit'
     */
    const VALUE_NAKIT = 'Nakit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OGS
     * @uses self::VALUE_HGS
     * @uses self::VALUE_NAKIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OGS,
            self::VALUE_HGS,
            self::VALUE_NAKIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
