<?php

namespace fk_\EnumType;

/**
 * This class stands for SozlesmeKaynagi EnumType
 * @subpackage Enumerations
 */
class SozlesmeKaynagi
{
    /**
     * Constant for value 'Serendip'
     * @return string 'Serendip'
     */
    const VALUE_SERENDIP = 'Serendip';
    /**
     * Constant for value 'CRM'
     * @return string 'CRM'
     */
    const VALUE_CRM = 'CRM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERENDIP
     * @uses self::VALUE_CRM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERENDIP,
            self::VALUE_CRM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
