<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KCariSozlesmeAnalizRaporu StructType
 * @subpackage Structs
 */
class KCariSozlesmeAnalizRaporu extends Entity
{
    /**
     * The TEFFiyatTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TEFFiyatTipi;
    /**
     * The IndirimOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IndirimOrani;
    /**
     * The ArtisOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ArtisOrani;
    /**
     * The BasDesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BasDesi;
    /**
     * The BitDesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BitDesi;
    /**
     * The BirimFiyat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BirimFiyat;
    /**
     * The Adet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Adet;
    /**
     * The ToplamFiyat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamFiyat;
    /**
     * The TasimaSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TasimaSekli;
    /**
     * The Cari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $Cari;
    /**
     * The Fatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $Fatura;
    /**
     * The Tesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellumPointer
     */
    public $Tesellum;
    /**
     * The Sozlesme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSozlesmePointer
     */
    public $Sozlesme;
    /**
     * The Birim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KBirimPointer
     */
    public $Birim;
    /**
     * The MesafeDerece
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KMesafeDerecePointer
     */
    public $MesafeDerece;
    /**
     * The Ekhizmet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KEkHizmetPointer
     */
    public $Ekhizmet;
    /**
     * Constructor method for KCariSozlesmeAnalizRaporu
     * @uses KCariSozlesmeAnalizRaporu::setTEFFiyatTipi()
     * @uses KCariSozlesmeAnalizRaporu::setIndirimOrani()
     * @uses KCariSozlesmeAnalizRaporu::setArtisOrani()
     * @uses KCariSozlesmeAnalizRaporu::setBasDesi()
     * @uses KCariSozlesmeAnalizRaporu::setBitDesi()
     * @uses KCariSozlesmeAnalizRaporu::setBirimFiyat()
     * @uses KCariSozlesmeAnalizRaporu::setAdet()
     * @uses KCariSozlesmeAnalizRaporu::setToplamFiyat()
     * @uses KCariSozlesmeAnalizRaporu::setTasimaSekli()
     * @uses KCariSozlesmeAnalizRaporu::setCari()
     * @uses KCariSozlesmeAnalizRaporu::setFatura()
     * @uses KCariSozlesmeAnalizRaporu::setTesellum()
     * @uses KCariSozlesmeAnalizRaporu::setSozlesme()
     * @uses KCariSozlesmeAnalizRaporu::setBirim()
     * @uses KCariSozlesmeAnalizRaporu::setMesafeDerece()
     * @uses KCariSozlesmeAnalizRaporu::setEkhizmet()
     * @param string $tEFFiyatTipi
     * @param float $indirimOrani
     * @param float $artisOrani
     * @param float $basDesi
     * @param float $bitDesi
     * @param float $birimFiyat
     * @param int $adet
     * @param float $toplamFiyat
     * @param string $tasimaSekli
     * @param \fk_\StructType\KCariPointer $cari
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @param \fk_\StructType\KSozlesmePointer $sozlesme
     * @param \fk_\StructType\KBirimPointer $birim
     * @param \fk_\StructType\KMesafeDerecePointer $mesafeDerece
     * @param \fk_\StructType\KEkHizmetPointer $ekhizmet
     */
    public function __construct($tEFFiyatTipi = null, $indirimOrani = null, $artisOrani = null, $basDesi = null, $bitDesi = null, $birimFiyat = null, $adet = null, $toplamFiyat = null, $tasimaSekli = null, \fk_\StructType\KCariPointer $cari = null, \fk_\StructType\KFaturaPointer $fatura = null, \fk_\StructType\KTesellumPointer $tesellum = null, \fk_\StructType\KSozlesmePointer $sozlesme = null, \fk_\StructType\KBirimPointer $birim = null, \fk_\StructType\KMesafeDerecePointer $mesafeDerece = null, \fk_\StructType\KEkHizmetPointer $ekhizmet = null)
    {
        $this
            ->setTEFFiyatTipi($tEFFiyatTipi)
            ->setIndirimOrani($indirimOrani)
            ->setArtisOrani($artisOrani)
            ->setBasDesi($basDesi)
            ->setBitDesi($bitDesi)
            ->setBirimFiyat($birimFiyat)
            ->setAdet($adet)
            ->setToplamFiyat($toplamFiyat)
            ->setTasimaSekli($tasimaSekli)
            ->setCari($cari)
            ->setFatura($fatura)
            ->setTesellum($tesellum)
            ->setSozlesme($sozlesme)
            ->setBirim($birim)
            ->setMesafeDerece($mesafeDerece)
            ->setEkhizmet($ekhizmet);
    }
    /**
     * Get TEFFiyatTipi value
     * @return string
     */
    public function getTEFFiyatTipi()
    {
        return $this->TEFFiyatTipi;
    }
    /**
     * Set TEFFiyatTipi value
     * @uses \fk_\EnumType\TESFATFiyatTip::valueIsValid()
     * @uses \fk_\EnumType\TESFATFiyatTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tEFFiyatTipi
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setTEFFiyatTipi($tEFFiyatTipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\TESFATFiyatTip::valueIsValid($tEFFiyatTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\TESFATFiyatTip', is_array($tEFFiyatTipi) ? implode(', ', $tEFFiyatTipi) : var_export($tEFFiyatTipi, true), implode(', ', \fk_\EnumType\TESFATFiyatTip::getValidValues())), __LINE__);
        }
        $this->TEFFiyatTipi = $tEFFiyatTipi;
        return $this;
    }
    /**
     * Get IndirimOrani value
     * @return float
     */
    public function getIndirimOrani()
    {
        return $this->IndirimOrani;
    }
    /**
     * Set IndirimOrani value
     * @param float $indirimOrani
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setIndirimOrani($indirimOrani = null)
    {
        // validation for constraint: float
        if (!is_null($indirimOrani) && !(is_float($indirimOrani) || is_numeric($indirimOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($indirimOrani, true), gettype($indirimOrani)), __LINE__);
        }
        $this->IndirimOrani = $indirimOrani;
        return $this;
    }
    /**
     * Get ArtisOrani value
     * @return float
     */
    public function getArtisOrani()
    {
        return $this->ArtisOrani;
    }
    /**
     * Set ArtisOrani value
     * @param float $artisOrani
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setArtisOrani($artisOrani = null)
    {
        // validation for constraint: float
        if (!is_null($artisOrani) && !(is_float($artisOrani) || is_numeric($artisOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($artisOrani, true), gettype($artisOrani)), __LINE__);
        }
        $this->ArtisOrani = $artisOrani;
        return $this;
    }
    /**
     * Get BasDesi value
     * @return float
     */
    public function getBasDesi()
    {
        return $this->BasDesi;
    }
    /**
     * Set BasDesi value
     * @param float $basDesi
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setBasDesi($basDesi = null)
    {
        // validation for constraint: float
        if (!is_null($basDesi) && !(is_float($basDesi) || is_numeric($basDesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basDesi, true), gettype($basDesi)), __LINE__);
        }
        $this->BasDesi = $basDesi;
        return $this;
    }
    /**
     * Get BitDesi value
     * @return float
     */
    public function getBitDesi()
    {
        return $this->BitDesi;
    }
    /**
     * Set BitDesi value
     * @param float $bitDesi
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setBitDesi($bitDesi = null)
    {
        // validation for constraint: float
        if (!is_null($bitDesi) && !(is_float($bitDesi) || is_numeric($bitDesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bitDesi, true), gettype($bitDesi)), __LINE__);
        }
        $this->BitDesi = $bitDesi;
        return $this;
    }
    /**
     * Get BirimFiyat value
     * @return float
     */
    public function getBirimFiyat()
    {
        return $this->BirimFiyat;
    }
    /**
     * Set BirimFiyat value
     * @param float $birimFiyat
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setBirimFiyat($birimFiyat = null)
    {
        // validation for constraint: float
        if (!is_null($birimFiyat) && !(is_float($birimFiyat) || is_numeric($birimFiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($birimFiyat, true), gettype($birimFiyat)), __LINE__);
        }
        $this->BirimFiyat = $birimFiyat;
        return $this;
    }
    /**
     * Get Adet value
     * @return int
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param int $adet
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: int
        if (!is_null($adet) && !(is_int($adet) || ctype_digit($adet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get ToplamFiyat value
     * @return float
     */
    public function getToplamFiyat()
    {
        return $this->ToplamFiyat;
    }
    /**
     * Set ToplamFiyat value
     * @param float $toplamFiyat
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setToplamFiyat($toplamFiyat = null)
    {
        // validation for constraint: float
        if (!is_null($toplamFiyat) && !(is_float($toplamFiyat) || is_numeric($toplamFiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamFiyat, true), gettype($toplamFiyat)), __LINE__);
        }
        $this->ToplamFiyat = $toplamFiyat;
        return $this;
    }
    /**
     * Get TasimaSekli value
     * @return string
     */
    public function getTasimaSekli()
    {
        return $this->TasimaSekli;
    }
    /**
     * Set TasimaSekli value
     * @uses \fk_\EnumType\KAracTuru::valueIsValid()
     * @uses \fk_\EnumType\KAracTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tasimaSekli
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setTasimaSekli($tasimaSekli = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KAracTuru::valueIsValid($tasimaSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KAracTuru', is_array($tasimaSekli) ? implode(', ', $tasimaSekli) : var_export($tasimaSekli, true), implode(', ', \fk_\EnumType\KAracTuru::getValidValues())), __LINE__);
        }
        $this->TasimaSekli = $tasimaSekli;
        return $this;
    }
    /**
     * Get Cari value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getCari()
    {
        return $this->Cari;
    }
    /**
     * Set Cari value
     * @param \fk_\StructType\KCariPointer $cari
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setCari(\fk_\StructType\KCariPointer $cari = null)
    {
        $this->Cari = $cari;
        return $this;
    }
    /**
     * Get Fatura value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getFatura()
    {
        return $this->Fatura;
    }
    /**
     * Set Fatura value
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setFatura(\fk_\StructType\KFaturaPointer $fatura = null)
    {
        $this->Fatura = $fatura;
        return $this;
    }
    /**
     * Get Tesellum value
     * @return \fk_\StructType\KTesellumPointer|null
     */
    public function getTesellum()
    {
        return $this->Tesellum;
    }
    /**
     * Set Tesellum value
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setTesellum(\fk_\StructType\KTesellumPointer $tesellum = null)
    {
        $this->Tesellum = $tesellum;
        return $this;
    }
    /**
     * Get Sozlesme value
     * @return \fk_\StructType\KSozlesmePointer|null
     */
    public function getSozlesme()
    {
        return $this->Sozlesme;
    }
    /**
     * Set Sozlesme value
     * @param \fk_\StructType\KSozlesmePointer $sozlesme
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setSozlesme(\fk_\StructType\KSozlesmePointer $sozlesme = null)
    {
        $this->Sozlesme = $sozlesme;
        return $this;
    }
    /**
     * Get Birim value
     * @return \fk_\StructType\KBirimPointer|null
     */
    public function getBirim()
    {
        return $this->Birim;
    }
    /**
     * Set Birim value
     * @param \fk_\StructType\KBirimPointer $birim
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setBirim(\fk_\StructType\KBirimPointer $birim = null)
    {
        $this->Birim = $birim;
        return $this;
    }
    /**
     * Get MesafeDerece value
     * @return \fk_\StructType\KMesafeDerecePointer|null
     */
    public function getMesafeDerece()
    {
        return $this->MesafeDerece;
    }
    /**
     * Set MesafeDerece value
     * @param \fk_\StructType\KMesafeDerecePointer $mesafeDerece
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setMesafeDerece(\fk_\StructType\KMesafeDerecePointer $mesafeDerece = null)
    {
        $this->MesafeDerece = $mesafeDerece;
        return $this;
    }
    /**
     * Get Ekhizmet value
     * @return \fk_\StructType\KEkHizmetPointer|null
     */
    public function getEkhizmet()
    {
        return $this->Ekhizmet;
    }
    /**
     * Set Ekhizmet value
     * @param \fk_\StructType\KEkHizmetPointer $ekhizmet
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public function setEkhizmet(\fk_\StructType\KEkHizmetPointer $ekhizmet = null)
    {
        $this->Ekhizmet = $ekhizmet;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KCariSozlesmeAnalizRaporu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
