<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KAracBakim StructType
 * @subpackage Structs
 */
class KAracBakim extends Entity
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The AracHareket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracHareketPointer
     */
    public $AracHareket;
    /**
     * Constructor method for KAracBakim
     * @uses KAracBakim::setAciklama()
     * @uses KAracBakim::setAracHareket()
     * @param string $aciklama
     * @param \fk_\StructType\KAracHareketPointer $aracHareket
     */
    public function __construct($aciklama = null, \fk_\StructType\KAracHareketPointer $aracHareket = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setAracHareket($aracHareket);
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KAracBakim
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get AracHareket value
     * @return \fk_\StructType\KAracHareketPointer|null
     */
    public function getAracHareket()
    {
        return $this->AracHareket;
    }
    /**
     * Set AracHareket value
     * @param \fk_\StructType\KAracHareketPointer $aracHareket
     * @return \fk_\StructType\KAracBakim
     */
    public function setAracHareket(\fk_\StructType\KAracHareketPointer $aracHareket = null)
    {
        $this->AracHareket = $aracHareket;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KAracBakim
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
