<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseEntity StructType
 * @subpackage Structs
 */
abstract class BaseEntity extends AbstractStructBase
{
    /**
     * The ReadState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadState;
    /**
     * Constructor method for BaseEntity
     * @uses BaseEntity::setReadState()
     * @param string $readState
     */
    public function __construct($readState = null)
    {
        $this
            ->setReadState($readState);
    }
    /**
     * Get ReadState value
     * @return string
     */
    public function getReadState()
    {
        return $this->ReadState;
    }
    /**
     * Set ReadState value
     * @uses \fk_\EnumType\EntityReadState::valueIsValid()
     * @uses \fk_\EnumType\EntityReadState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $readState
     * @return \fk_\StructType\BaseEntity
     */
    public function setReadState($readState = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\EntityReadState::valueIsValid($readState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\EntityReadState', is_array($readState) ? implode(', ', $readState) : var_export($readState, true), implode(', ', \fk_\EnumType\EntityReadState::getValidValues())), __LINE__);
        }
        $this->ReadState = $readState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\BaseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
