<?php

namespace fk_\EnumType;

/**
 * This class stands for ErisimTipi EnumType
 * @subpackage Enumerations
 */
class ErisimTipi
{
    /**
     * Constant for value 'Soap'
     * @return string 'Soap'
     */
    const VALUE_SOAP = 'Soap';
    /**
     * Constant for value 'Rest'
     * @return string 'Rest'
     */
    const VALUE_REST = 'Rest';
    /**
     * Constant for value 'Local'
     * @return string 'Local'
     */
    const VALUE_LOCAL = 'Local';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOAP
     * @uses self::VALUE_REST
     * @uses self::VALUE_LOCAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOAP,
            self::VALUE_REST,
            self::VALUE_LOCAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
