<?php

namespace fk_\EnumType;

/**
 * This class stands for IslemParaCinsi EnumType
 * @subpackage Enumerations
 */
class IslemParaCinsi
{
    /**
     * Constant for value 'Hicbiri'
     * @return string 'Hicbiri'
     */
    const VALUE_HICBIRI = 'Hicbiri';
    /**
     * Constant for value 'Yerel'
     * @return string 'Yerel'
     */
    const VALUE_YEREL = 'Yerel';
    /**
     * Constant for value 'Doviz'
     * @return string 'Doviz'
     */
    const VALUE_DOVIZ = 'Doviz';
    /**
     * Constant for value 'Hepsi'
     * @return string 'Hepsi'
     */
    const VALUE_HEPSI = 'Hepsi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HICBIRI
     * @uses self::VALUE_YEREL
     * @uses self::VALUE_DOVIZ
     * @uses self::VALUE_HEPSI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HICBIRI,
            self::VALUE_YEREL,
            self::VALUE_DOVIZ,
            self::VALUE_HEPSI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
