<?php

namespace fk_\EnumType;

/**
 * This class stands for TESFATFiyatTip EnumType
 * @subpackage Enumerations
 */
class TESFATFiyatTip
{
    /**
     * Constant for value 'ToplamDesi'
     * @return string 'ToplamDesi'
     */
    const VALUE_TOPLAM_DESI = 'ToplamDesi';
    /**
     * Constant for value 'Kolibasi'
     * @return string 'Kolibasi'
     */
    const VALUE_KOLIBASI = 'Kolibasi';
    /**
     * Constant for value 'Desi_Kg'
     * @return string 'Desi_Kg'
     */
    const VALUE_DESI_KG = 'Desi_Kg';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOPLAM_DESI
     * @uses self::VALUE_KOLIBASI
     * @uses self::VALUE_DESI_KG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOPLAM_DESI,
            self::VALUE_KOLIBASI,
            self::VALUE_DESI_KG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
