<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KTesFatProforma StructType
 * @subpackage Structs
 */
class KTesFatProforma extends Entity
{
    /**
     * The Adet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Adet;
    /**
     * The BirimFiyat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BirimFiyat;
    /**
     * The Fatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $Fatura;
    /**
     * The Tesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellumPointer
     */
    public $Tesellum;
    /**
     * The GonderininTanimi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonderininTanimi;
    /**
     * The GonderininTarifeKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GonderininTarifeKodu;
    /**
     * The Mensei
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mensei;
    /**
     * Constructor method for KTesFatProforma
     * @uses KTesFatProforma::setAdet()
     * @uses KTesFatProforma::setBirimFiyat()
     * @uses KTesFatProforma::setFatura()
     * @uses KTesFatProforma::setTesellum()
     * @uses KTesFatProforma::setGonderininTanimi()
     * @uses KTesFatProforma::setGonderininTarifeKodu()
     * @uses KTesFatProforma::setMensei()
     * @param string $adet
     * @param float $birimFiyat
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @param string $gonderininTanimi
     * @param string $gonderininTarifeKodu
     * @param string $mensei
     */
    public function __construct($adet = null, $birimFiyat = null, \fk_\StructType\KFaturaPointer $fatura = null, \fk_\StructType\KTesellumPointer $tesellum = null, $gonderininTanimi = null, $gonderininTarifeKodu = null, $mensei = null)
    {
        $this
            ->setAdet($adet)
            ->setBirimFiyat($birimFiyat)
            ->setFatura($fatura)
            ->setTesellum($tesellum)
            ->setGonderininTanimi($gonderininTanimi)
            ->setGonderininTarifeKodu($gonderininTarifeKodu)
            ->setMensei($mensei);
    }
    /**
     * Get Adet value
     * @return string
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param string $adet
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: string
        if (!is_null($adet) && !is_string($adet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get BirimFiyat value
     * @return float
     */
    public function getBirimFiyat()
    {
        return $this->BirimFiyat;
    }
    /**
     * Set BirimFiyat value
     * @param float $birimFiyat
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setBirimFiyat($birimFiyat = null)
    {
        // validation for constraint: float
        if (!is_null($birimFiyat) && !(is_float($birimFiyat) || is_numeric($birimFiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($birimFiyat, true), gettype($birimFiyat)), __LINE__);
        }
        $this->BirimFiyat = $birimFiyat;
        return $this;
    }
    /**
     * Get Fatura value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getFatura()
    {
        return $this->Fatura;
    }
    /**
     * Set Fatura value
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setFatura(\fk_\StructType\KFaturaPointer $fatura = null)
    {
        $this->Fatura = $fatura;
        return $this;
    }
    /**
     * Get Tesellum value
     * @return \fk_\StructType\KTesellumPointer|null
     */
    public function getTesellum()
    {
        return $this->Tesellum;
    }
    /**
     * Set Tesellum value
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setTesellum(\fk_\StructType\KTesellumPointer $tesellum = null)
    {
        $this->Tesellum = $tesellum;
        return $this;
    }
    /**
     * Get GonderininTanimi value
     * @return string|null
     */
    public function getGonderininTanimi()
    {
        return $this->GonderininTanimi;
    }
    /**
     * Set GonderininTanimi value
     * @param string $gonderininTanimi
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setGonderininTanimi($gonderininTanimi = null)
    {
        // validation for constraint: string
        if (!is_null($gonderininTanimi) && !is_string($gonderininTanimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonderininTanimi, true), gettype($gonderininTanimi)), __LINE__);
        }
        $this->GonderininTanimi = $gonderininTanimi;
        return $this;
    }
    /**
     * Get GonderininTarifeKodu value
     * @return string|null
     */
    public function getGonderininTarifeKodu()
    {
        return $this->GonderininTarifeKodu;
    }
    /**
     * Set GonderininTarifeKodu value
     * @param string $gonderininTarifeKodu
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setGonderininTarifeKodu($gonderininTarifeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($gonderininTarifeKodu) && !is_string($gonderininTarifeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gonderininTarifeKodu, true), gettype($gonderininTarifeKodu)), __LINE__);
        }
        $this->GonderininTarifeKodu = $gonderininTarifeKodu;
        return $this;
    }
    /**
     * Get Mensei value
     * @return string|null
     */
    public function getMensei()
    {
        return $this->Mensei;
    }
    /**
     * Set Mensei value
     * @param string $mensei
     * @return \fk_\StructType\KTesFatProforma
     */
    public function setMensei($mensei = null)
    {
        // validation for constraint: string
        if (!is_null($mensei) && !is_string($mensei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensei, true), gettype($mensei)), __LINE__);
        }
        $this->Mensei = $mensei;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KTesFatProforma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
