<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKargoHareket StructType
 * @subpackage Structs
 */
class KKargoHareket extends Entity
{
    /**
     * The HareketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTip;
    /**
     * The HareketTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTar;
    /**
     * The HareketKaynak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketKaynak;
    /**
     * The IslemNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IslemNo;
    /**
     * The RotaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RotaNo;
    /**
     * The Kargo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KKargoPointer
     */
    public $Kargo;
    /**
     * The AracSeferAyak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracSeferAyakPointer
     */
    public $AracSeferAyak;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $Sube;
    /**
     * The Arac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracKaraPointer
     */
    public $Arac;
    /**
     * The AracSefer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracSeferPointer
     */
    public $AracSefer;
    /**
     * The KargoTeslimat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KKargoTeslimatPointer
     */
    public $KargoTeslimat;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Kurye
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KPersonelPointer
     */
    public $Kurye;
    /**
     * Constructor method for KKargoHareket
     * @uses KKargoHareket::setHareketTip()
     * @uses KKargoHareket::setHareketTar()
     * @uses KKargoHareket::setHareketKaynak()
     * @uses KKargoHareket::setIslemNo()
     * @uses KKargoHareket::setRotaNo()
     * @uses KKargoHareket::setKargo()
     * @uses KKargoHareket::setAracSeferAyak()
     * @uses KKargoHareket::setSube()
     * @uses KKargoHareket::setArac()
     * @uses KKargoHareket::setAracSefer()
     * @uses KKargoHareket::setKargoTeslimat()
     * @uses KKargoHareket::setAciklama()
     * @uses KKargoHareket::setKurye()
     * @param string $hareketTip
     * @param string $hareketTar
     * @param string $hareketKaynak
     * @param int $islemNo
     * @param int $rotaNo
     * @param \fk_\StructType\KKargoPointer $kargo
     * @param \fk_\StructType\KAracSeferAyakPointer $aracSeferAyak
     * @param \fk_\StructType\KSubePointer $sube
     * @param \fk_\StructType\KAracKaraPointer $arac
     * @param \fk_\StructType\KAracSeferPointer $aracSefer
     * @param \fk_\StructType\KKargoTeslimatPointer $kargoTeslimat
     * @param string $aciklama
     * @param \fk_\StructType\KPersonelPointer $kurye
     */
    public function __construct($hareketTip = null, $hareketTar = null, $hareketKaynak = null, $islemNo = null, $rotaNo = null, \fk_\StructType\KKargoPointer $kargo = null, \fk_\StructType\KAracSeferAyakPointer $aracSeferAyak = null, \fk_\StructType\KSubePointer $sube = null, \fk_\StructType\KAracKaraPointer $arac = null, \fk_\StructType\KAracSeferPointer $aracSefer = null, \fk_\StructType\KKargoTeslimatPointer $kargoTeslimat = null, $aciklama = null, \fk_\StructType\KPersonelPointer $kurye = null)
    {
        $this
            ->setHareketTip($hareketTip)
            ->setHareketTar($hareketTar)
            ->setHareketKaynak($hareketKaynak)
            ->setIslemNo($islemNo)
            ->setRotaNo($rotaNo)
            ->setKargo($kargo)
            ->setAracSeferAyak($aracSeferAyak)
            ->setSube($sube)
            ->setArac($arac)
            ->setAracSefer($aracSefer)
            ->setKargoTeslimat($kargoTeslimat)
            ->setAciklama($aciklama)
            ->setKurye($kurye);
    }
    /**
     * Get HareketTip value
     * @return string
     */
    public function getHareketTip()
    {
        return $this->HareketTip;
    }
    /**
     * Set HareketTip value
     * @uses \fk_\EnumType\KargoHareketTip::valueIsValid()
     * @uses \fk_\EnumType\KargoHareketTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketTip
     * @return \fk_\StructType\KKargoHareket
     */
    public function setHareketTip($hareketTip = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KargoHareketTip::valueIsValid($hareketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KargoHareketTip', is_array($hareketTip) ? implode(', ', $hareketTip) : var_export($hareketTip, true), implode(', ', \fk_\EnumType\KargoHareketTip::getValidValues())), __LINE__);
        }
        $this->HareketTip = $hareketTip;
        return $this;
    }
    /**
     * Get HareketTar value
     * @return string
     */
    public function getHareketTar()
    {
        return $this->HareketTar;
    }
    /**
     * Set HareketTar value
     * @param string $hareketTar
     * @return \fk_\StructType\KKargoHareket
     */
    public function setHareketTar($hareketTar = null)
    {
        // validation for constraint: string
        if (!is_null($hareketTar) && !is_string($hareketTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hareketTar, true), gettype($hareketTar)), __LINE__);
        }
        $this->HareketTar = $hareketTar;
        return $this;
    }
    /**
     * Get HareketKaynak value
     * @return string
     */
    public function getHareketKaynak()
    {
        return $this->HareketKaynak;
    }
    /**
     * Set HareketKaynak value
     * @uses \fk_\EnumType\KargoHareketKaynak::valueIsValid()
     * @uses \fk_\EnumType\KargoHareketKaynak::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketKaynak
     * @return \fk_\StructType\KKargoHareket
     */
    public function setHareketKaynak($hareketKaynak = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KargoHareketKaynak::valueIsValid($hareketKaynak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KargoHareketKaynak', is_array($hareketKaynak) ? implode(', ', $hareketKaynak) : var_export($hareketKaynak, true), implode(', ', \fk_\EnumType\KargoHareketKaynak::getValidValues())), __LINE__);
        }
        $this->HareketKaynak = $hareketKaynak;
        return $this;
    }
    /**
     * Get IslemNo value
     * @return int
     */
    public function getIslemNo()
    {
        return $this->IslemNo;
    }
    /**
     * Set IslemNo value
     * @param int $islemNo
     * @return \fk_\StructType\KKargoHareket
     */
    public function setIslemNo($islemNo = null)
    {
        // validation for constraint: int
        if (!is_null($islemNo) && !(is_int($islemNo) || ctype_digit($islemNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islemNo, true), gettype($islemNo)), __LINE__);
        }
        $this->IslemNo = $islemNo;
        return $this;
    }
    /**
     * Get RotaNo value
     * @return int
     */
    public function getRotaNo()
    {
        return $this->RotaNo;
    }
    /**
     * Set RotaNo value
     * @param int $rotaNo
     * @return \fk_\StructType\KKargoHareket
     */
    public function setRotaNo($rotaNo = null)
    {
        // validation for constraint: int
        if (!is_null($rotaNo) && !(is_int($rotaNo) || ctype_digit($rotaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rotaNo, true), gettype($rotaNo)), __LINE__);
        }
        $this->RotaNo = $rotaNo;
        return $this;
    }
    /**
     * Get Kargo value
     * @return \fk_\StructType\KKargoPointer|null
     */
    public function getKargo()
    {
        return $this->Kargo;
    }
    /**
     * Set Kargo value
     * @param \fk_\StructType\KKargoPointer $kargo
     * @return \fk_\StructType\KKargoHareket
     */
    public function setKargo(\fk_\StructType\KKargoPointer $kargo = null)
    {
        $this->Kargo = $kargo;
        return $this;
    }
    /**
     * Get AracSeferAyak value
     * @return \fk_\StructType\KAracSeferAyakPointer|null
     */
    public function getAracSeferAyak()
    {
        return $this->AracSeferAyak;
    }
    /**
     * Set AracSeferAyak value
     * @param \fk_\StructType\KAracSeferAyakPointer $aracSeferAyak
     * @return \fk_\StructType\KKargoHareket
     */
    public function setAracSeferAyak(\fk_\StructType\KAracSeferAyakPointer $aracSeferAyak = null)
    {
        $this->AracSeferAyak = $aracSeferAyak;
        return $this;
    }
    /**
     * Get Sube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \fk_\StructType\KSubePointer $sube
     * @return \fk_\StructType\KKargoHareket
     */
    public function setSube(\fk_\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get Arac value
     * @return \fk_\StructType\KAracKaraPointer|null
     */
    public function getArac()
    {
        return $this->Arac;
    }
    /**
     * Set Arac value
     * @param \fk_\StructType\KAracKaraPointer $arac
     * @return \fk_\StructType\KKargoHareket
     */
    public function setArac(\fk_\StructType\KAracKaraPointer $arac = null)
    {
        $this->Arac = $arac;
        return $this;
    }
    /**
     * Get AracSefer value
     * @return \fk_\StructType\KAracSeferPointer|null
     */
    public function getAracSefer()
    {
        return $this->AracSefer;
    }
    /**
     * Set AracSefer value
     * @param \fk_\StructType\KAracSeferPointer $aracSefer
     * @return \fk_\StructType\KKargoHareket
     */
    public function setAracSefer(\fk_\StructType\KAracSeferPointer $aracSefer = null)
    {
        $this->AracSefer = $aracSefer;
        return $this;
    }
    /**
     * Get KargoTeslimat value
     * @return \fk_\StructType\KKargoTeslimatPointer|null
     */
    public function getKargoTeslimat()
    {
        return $this->KargoTeslimat;
    }
    /**
     * Set KargoTeslimat value
     * @param \fk_\StructType\KKargoTeslimatPointer $kargoTeslimat
     * @return \fk_\StructType\KKargoHareket
     */
    public function setKargoTeslimat(\fk_\StructType\KKargoTeslimatPointer $kargoTeslimat = null)
    {
        $this->KargoTeslimat = $kargoTeslimat;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KKargoHareket
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Kurye value
     * @return \fk_\StructType\KPersonelPointer|null
     */
    public function getKurye()
    {
        return $this->Kurye;
    }
    /**
     * Set Kurye value
     * @param \fk_\StructType\KPersonelPointer $kurye
     * @return \fk_\StructType\KKargoHareket
     */
    public function setKurye(\fk_\StructType\KPersonelPointer $kurye = null)
    {
        $this->Kurye = $kurye;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KKargoHareket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
