<?php

namespace fk_\EnumType;

/**
 * This class stands for KEvrakTuru EnumType
 * @subpackage Enumerations
 */
class KEvrakTuru
{
    /**
     * Constant for value 'Fatura'
     * @return string 'Fatura'
     */
    const VALUE_FATURA = 'Fatura';
    /**
     * Constant for value 'Tesellum'
     * @return string 'Tesellum'
     */
    const VALUE_TESELLUM = 'Tesellum';
    /**
     * Constant for value 'ElAtfsi'
     * @return string 'ElAtfsi'
     */
    const VALUE_EL_ATFSI = 'ElAtfsi';
    /**
     * Constant for value 'Hepsi'
     * @return string 'Hepsi'
     */
    const VALUE_HEPSI = 'Hepsi';
    /**
     * Constant for value 'Belirsiz'
     * @return string 'Belirsiz'
     */
    const VALUE_BELIRSIZ = 'Belirsiz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FATURA
     * @uses self::VALUE_TESELLUM
     * @uses self::VALUE_EL_ATFSI
     * @uses self::VALUE_HEPSI
     * @uses self::VALUE_BELIRSIZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FATURA,
            self::VALUE_TESELLUM,
            self::VALUE_EL_ATFSI,
            self::VALUE_HEPSI,
            self::VALUE_BELIRSIZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
