<?php

namespace fk_\EnumType;

/**
 * This class stands for KWebKargoBirim EnumType
 * @subpackage Enumerations
 */
class KWebKargoBirim
{
    /**
     * Constant for value 'BELIRSIZ'
     * @return string 'BELIRSIZ'
     */
    const VALUE_BELIRSIZ = 'BELIRSIZ';
    /**
     * Constant for value 'DOSYA'
     * @return string 'DOSYA'
     */
    const VALUE_DOSYA = 'DOSYA';
    /**
     * Constant for value 'Mİ'
     * @return string 'Mİ'
     */
    const VALUE_M_İ = 'Mİ';
    /**
     * Constant for value 'KOLİ'
     * @return string 'KOLİ'
     */
    const VALUE_KOL_İ = 'KOLİ';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BELIRSIZ
     * @uses self::VALUE_DOSYA
     * @uses self::VALUE_M_İ
     * @uses self::VALUE_KOL_İ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BELIRSIZ,
            self::VALUE_DOSYA,
            self::VALUE_M_İ,
            self::VALUE_KOL_İ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
