<?php

namespace fk_\EnumType;

/**
 * This class stands for AracHareketTip EnumType
 * @subpackage Enumerations
 */
class AracHareketTip
{
    /**
     * Constant for value 'AracSeferHazirlikBasladi'
     * @return string 'AracSeferHazirlikBasladi'
     */
    const VALUE_ARAC_SEFER_HAZIRLIK_BASLADI = 'AracSeferHazirlikBasladi';
    /**
     * Constant for value 'AracYuklemeBasladi'
     * @return string 'AracYuklemeBasladi'
     */
    const VALUE_ARAC_YUKLEME_BASLADI = 'AracYuklemeBasladi';
    /**
     * Constant for value 'AracSefereBasladi'
     * @return string 'AracSefereBasladi'
     */
    const VALUE_ARAC_SEFERE_BASLADI = 'AracSefereBasladi';
    /**
     * Constant for value 'AracSeferiTamamladi'
     * @return string 'AracSeferiTamamladi'
     */
    const VALUE_ARAC_SEFERI_TAMAMLADI = 'AracSeferiTamamladi';
    /**
     * Constant for value 'AracBosaltmaBasladi'
     * @return string 'AracBosaltmaBasladi'
     */
    const VALUE_ARAC_BOSALTMA_BASLADI = 'AracBosaltmaBasladi';
    /**
     * Constant for value 'AracHazirlandi'
     * @return string 'AracHazirlandi'
     */
    const VALUE_ARAC_HAZIRLANDI = 'AracHazirlandi';
    /**
     * Constant for value 'AracServiseGirdi'
     * @return string 'AracServiseGirdi'
     */
    const VALUE_ARAC_SERVISE_GIRDI = 'AracServiseGirdi';
    /**
     * Constant for value 'AracKayitDuzeltme'
     * @return string 'AracKayitDuzeltme'
     */
    const VALUE_ARAC_KAYIT_DUZELTME = 'AracKayitDuzeltme';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARAC_SEFER_HAZIRLIK_BASLADI
     * @uses self::VALUE_ARAC_YUKLEME_BASLADI
     * @uses self::VALUE_ARAC_SEFERE_BASLADI
     * @uses self::VALUE_ARAC_SEFERI_TAMAMLADI
     * @uses self::VALUE_ARAC_BOSALTMA_BASLADI
     * @uses self::VALUE_ARAC_HAZIRLANDI
     * @uses self::VALUE_ARAC_SERVISE_GIRDI
     * @uses self::VALUE_ARAC_KAYIT_DUZELTME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARAC_SEFER_HAZIRLIK_BASLADI,
            self::VALUE_ARAC_YUKLEME_BASLADI,
            self::VALUE_ARAC_SEFERE_BASLADI,
            self::VALUE_ARAC_SEFERI_TAMAMLADI,
            self::VALUE_ARAC_BOSALTMA_BASLADI,
            self::VALUE_ARAC_HAZIRLANDI,
            self::VALUE_ARAC_SERVISE_GIRDI,
            self::VALUE_ARAC_KAYIT_DUZELTME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
