<?php

namespace fk_\EnumType;

/**
 * This class stands for SevkAdresTip EnumType
 * @subpackage Enumerations
 */
class SevkAdresTip
{
    /**
     * Constant for value 'Istasyon'
     * @return string 'Istasyon'
     */
    const VALUE_ISTASYON = 'Istasyon';
    /**
     * Constant for value 'Liman'
     * @return string 'Liman'
     */
    const VALUE_LIMAN = 'Liman';
    /**
     * Constant for value 'Gumruk'
     * @return string 'Gumruk'
     */
    const VALUE_GUMRUK = 'Gumruk';
    /**
     * Constant for value 'Depo'
     * @return string 'Depo'
     */
    const VALUE_DEPO = 'Depo';
    /**
     * Constant for value 'Garaj'
     * @return string 'Garaj'
     */
    const VALUE_GARAJ = 'Garaj';
    /**
     * Constant for value 'Mevki'
     * @return string 'Mevki'
     */
    const VALUE_MEVKI = 'Mevki';
    /**
     * Constant for value 'HavaLimani'
     * @return string 'HavaLimani'
     */
    const VALUE_HAVA_LIMANI = 'HavaLimani';
    /**
     * Constant for value 'SerbestBolge'
     * @return string 'SerbestBolge'
     */
    const VALUE_SERBEST_BOLGE = 'SerbestBolge';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ISTASYON
     * @uses self::VALUE_LIMAN
     * @uses self::VALUE_GUMRUK
     * @uses self::VALUE_DEPO
     * @uses self::VALUE_GARAJ
     * @uses self::VALUE_MEVKI
     * @uses self::VALUE_HAVA_LIMANI
     * @uses self::VALUE_SERBEST_BOLGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ISTASYON,
            self::VALUE_LIMAN,
            self::VALUE_GUMRUK,
            self::VALUE_DEPO,
            self::VALUE_GARAJ,
            self::VALUE_MEVKI,
            self::VALUE_HAVA_LIMANI,
            self::VALUE_SERBEST_BOLGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
