<?php

namespace fk_\EnumType;

/**
 * This class stands for KPersonelGirisCikisEnum EnumType
 * @subpackage Enumerations
 */
class KPersonelGirisCikisEnum
{
    /**
     * Constant for value 'Giris'
     * @return string 'Giris'
     */
    const VALUE_GIRIS = 'Giris';
    /**
     * Constant for value 'Cikis'
     * @return string 'Cikis'
     */
    const VALUE_CIKIS = 'Cikis';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GIRIS
     * @uses self::VALUE_CIKIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GIRIS,
            self::VALUE_CIKIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
