<?php

namespace fk_\EnumType;

/**
 * This class stands for GonderiKaynak EnumType
 * @subpackage Enumerations
 */
class GonderiKaynak
{
    /**
     * Constant for value 'Standart'
     * @return string 'Standart'
     */
    const VALUE_STANDART = 'Standart';
    /**
     * Constant for value 'Web'
     * @return string 'Web'
     */
    const VALUE_WEB = 'Web';
    /**
     * Constant for value 'Pazaryeri'
     * @return string 'Pazaryeri'
     */
    const VALUE_PAZARYERI = 'Pazaryeri';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDART
     * @uses self::VALUE_WEB
     * @uses self::VALUE_PAZARYERI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDART,
            self::VALUE_WEB,
            self::VALUE_PAZARYERI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
