<?php

namespace fk_\EnumType;

/**
 * This class stands for TOVizeDurumu EnumType
 * @subpackage Enumerations
 */
class TOVizeDurumu
{
    /**
     * Constant for value 'Vizeli'
     * @return string 'Vizeli'
     */
    const VALUE_VIZELI = 'Vizeli';
    /**
     * Constant for value 'Vizesiz'
     * @return string 'Vizesiz'
     */
    const VALUE_VIZESIZ = 'Vizesiz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VIZELI
     * @uses self::VALUE_VIZESIZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VIZELI,
            self::VALUE_VIZESIZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
