<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSurucuHareket StructType
 * @subpackage Structs
 */
class KSurucuHareket extends Entity
{
    /**
     * The HareketTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTar;
    /**
     * The HareketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTip;
    /**
     * The Surucu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSurucuPointer
     */
    public $Surucu;
    /**
     * The AracSeferAyak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracSeferAyakPointer
     */
    public $AracSeferAyak;
    /**
     * The HareketSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $HareketSube;
    /**
     * The HareketYer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSevkAdresPointer
     */
    public $HareketYer;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * Constructor method for KSurucuHareket
     * @uses KSurucuHareket::setHareketTar()
     * @uses KSurucuHareket::setHareketTip()
     * @uses KSurucuHareket::setSurucu()
     * @uses KSurucuHareket::setAracSeferAyak()
     * @uses KSurucuHareket::setHareketSube()
     * @uses KSurucuHareket::setHareketYer()
     * @uses KSurucuHareket::setAciklama()
     * @param string $hareketTar
     * @param string $hareketTip
     * @param \fk_\StructType\KSurucuPointer $surucu
     * @param \fk_\StructType\KAracSeferAyakPointer $aracSeferAyak
     * @param \fk_\StructType\KSubePointer $hareketSube
     * @param \fk_\StructType\KSevkAdresPointer $hareketYer
     * @param string $aciklama
     */
    public function __construct($hareketTar = null, $hareketTip = null, \fk_\StructType\KSurucuPointer $surucu = null, \fk_\StructType\KAracSeferAyakPointer $aracSeferAyak = null, \fk_\StructType\KSubePointer $hareketSube = null, \fk_\StructType\KSevkAdresPointer $hareketYer = null, $aciklama = null)
    {
        $this
            ->setHareketTar($hareketTar)
            ->setHareketTip($hareketTip)
            ->setSurucu($surucu)
            ->setAracSeferAyak($aracSeferAyak)
            ->setHareketSube($hareketSube)
            ->setHareketYer($hareketYer)
            ->setAciklama($aciklama);
    }
    /**
     * Get HareketTar value
     * @return string
     */
    public function getHareketTar()
    {
        return $this->HareketTar;
    }
    /**
     * Set HareketTar value
     * @param string $hareketTar
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setHareketTar($hareketTar = null)
    {
        // validation for constraint: string
        if (!is_null($hareketTar) && !is_string($hareketTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hareketTar, true), gettype($hareketTar)), __LINE__);
        }
        $this->HareketTar = $hareketTar;
        return $this;
    }
    /**
     * Get HareketTip value
     * @return string
     */
    public function getHareketTip()
    {
        return $this->HareketTip;
    }
    /**
     * Set HareketTip value
     * @uses \fk_\EnumType\AracHareketTip::valueIsValid()
     * @uses \fk_\EnumType\AracHareketTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketTip
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setHareketTip($hareketTip = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\AracHareketTip::valueIsValid($hareketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\AracHareketTip', is_array($hareketTip) ? implode(', ', $hareketTip) : var_export($hareketTip, true), implode(', ', \fk_\EnumType\AracHareketTip::getValidValues())), __LINE__);
        }
        $this->HareketTip = $hareketTip;
        return $this;
    }
    /**
     * Get Surucu value
     * @return \fk_\StructType\KSurucuPointer|null
     */
    public function getSurucu()
    {
        return $this->Surucu;
    }
    /**
     * Set Surucu value
     * @param \fk_\StructType\KSurucuPointer $surucu
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setSurucu(\fk_\StructType\KSurucuPointer $surucu = null)
    {
        $this->Surucu = $surucu;
        return $this;
    }
    /**
     * Get AracSeferAyak value
     * @return \fk_\StructType\KAracSeferAyakPointer|null
     */
    public function getAracSeferAyak()
    {
        return $this->AracSeferAyak;
    }
    /**
     * Set AracSeferAyak value
     * @param \fk_\StructType\KAracSeferAyakPointer $aracSeferAyak
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setAracSeferAyak(\fk_\StructType\KAracSeferAyakPointer $aracSeferAyak = null)
    {
        $this->AracSeferAyak = $aracSeferAyak;
        return $this;
    }
    /**
     * Get HareketSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getHareketSube()
    {
        return $this->HareketSube;
    }
    /**
     * Set HareketSube value
     * @param \fk_\StructType\KSubePointer $hareketSube
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setHareketSube(\fk_\StructType\KSubePointer $hareketSube = null)
    {
        $this->HareketSube = $hareketSube;
        return $this;
    }
    /**
     * Get HareketYer value
     * @return \fk_\StructType\KSevkAdresPointer|null
     */
    public function getHareketYer()
    {
        return $this->HareketYer;
    }
    /**
     * Set HareketYer value
     * @param \fk_\StructType\KSevkAdresPointer $hareketYer
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setHareketYer(\fk_\StructType\KSevkAdresPointer $hareketYer = null)
    {
        $this->HareketYer = $hareketYer;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KSurucuHareket
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KSurucuHareket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
