<?php

namespace fk_\EnumType;

/**
 * This class stands for KAraciFirma EnumType
 * @subpackage Enumerations
 */
class KAraciFirma
{
    /**
     * Constant for value 'Yok'
     * @return string 'Yok'
     */
    const VALUE_YOK = 'Yok';
    /**
     * Constant for value 'DHL'
     * @return string 'DHL'
     */
    const VALUE_DHL = 'DHL';
    /**
     * Constant for value 'TNT'
     * @return string 'TNT'
     */
    const VALUE_TNT = 'TNT';
    /**
     * Constant for value 'Diger'
     * @return string 'Diger'
     */
    const VALUE_DIGER = 'Diger';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_YOK
     * @uses self::VALUE_DHL
     * @uses self::VALUE_TNT
     * @uses self::VALUE_DIGER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_YOK,
            self::VALUE_DHL,
            self::VALUE_TNT,
            self::VALUE_DIGER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
