<?php

namespace fk_\EnumType;

/**
 * This class stands for SozlesmeKullanilacakBelge EnumType
 * @subpackage Enumerations
 */
class SozlesmeKullanilacakBelge
{
    /**
     * Constant for value 'Tesellum'
     * @return string 'Tesellum'
     */
    const VALUE_TESELLUM = 'Tesellum';
    /**
     * Constant for value 'Fatura'
     * @return string 'Fatura'
     */
    const VALUE_FATURA = 'Fatura';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TESELLUM
     * @uses self::VALUE_FATURA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TESELLUM,
            self::VALUE_FATURA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
