<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KDesiKgKontrol StructType
 * @subpackage Structs
 */
class KDesiKgKontrol extends Entity
{
    /**
     * The TutanakTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TutanakTarihi;
    /**
     * The EvrakSiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EvrakSiraNo;
    /**
     * The EvrakTarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakTarih;
    /**
     * The EvrakParcaAdedi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EvrakParcaAdedi;
    /**
     * The OlcumParcaAdedi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OlcumParcaAdedi;
    /**
     * The EvrakDesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EvrakDesi;
    /**
     * The OlcumDesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OlcumDesi;
    /**
     * The EvrakKg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EvrakKg;
    /**
     * The OlcumKg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OlcumKg;
    /**
     * The EvrakIptalBaslat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EvrakIptalBaslat;
    /**
     * The YeniEvrakSiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $YeniEvrakSiraNo;
    /**
     * The IsKEKFaturasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKEKFaturasi;
    /**
     * The KekTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KekTuru;
    /**
     * The FaturalanmamaNedenleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FaturalanmamaNedenleri;
    /**
     * The IslemSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $IslemSube;
    /**
     * The CikisSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $CikisSube;
    /**
     * The CikisBolge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $CikisBolge;
    /**
     * The VarisSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $VarisSube;
    /**
     * The Arac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracKaraPointer
     */
    public $Arac;
    /**
     * The Plaka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Plaka;
    /**
     * The Tesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellumPointer
     */
    public $Tesellum;
    /**
     * The Fatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $Fatura;
    /**
     * The EvrakSeriNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakSeriNo;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The EvrakIptal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KEvrakIptalPointer
     */
    public $EvrakIptal;
    /**
     * The YeniEvrakSeriNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $YeniEvrakSeriNo;
    /**
     * Constructor method for KDesiKgKontrol
     * @uses KDesiKgKontrol::setTutanakTarihi()
     * @uses KDesiKgKontrol::setEvrakSiraNo()
     * @uses KDesiKgKontrol::setEvrakTarih()
     * @uses KDesiKgKontrol::setEvrakParcaAdedi()
     * @uses KDesiKgKontrol::setOlcumParcaAdedi()
     * @uses KDesiKgKontrol::setEvrakDesi()
     * @uses KDesiKgKontrol::setOlcumDesi()
     * @uses KDesiKgKontrol::setEvrakKg()
     * @uses KDesiKgKontrol::setOlcumKg()
     * @uses KDesiKgKontrol::setEvrakIptalBaslat()
     * @uses KDesiKgKontrol::setYeniEvrakSiraNo()
     * @uses KDesiKgKontrol::setIsKEKFaturasi()
     * @uses KDesiKgKontrol::setKekTuru()
     * @uses KDesiKgKontrol::setFaturalanmamaNedenleri()
     * @uses KDesiKgKontrol::setIslemSube()
     * @uses KDesiKgKontrol::setCikisSube()
     * @uses KDesiKgKontrol::setCikisBolge()
     * @uses KDesiKgKontrol::setVarisSube()
     * @uses KDesiKgKontrol::setArac()
     * @uses KDesiKgKontrol::setPlaka()
     * @uses KDesiKgKontrol::setTesellum()
     * @uses KDesiKgKontrol::setFatura()
     * @uses KDesiKgKontrol::setEvrakSeriNo()
     * @uses KDesiKgKontrol::setAciklama()
     * @uses KDesiKgKontrol::setEvrakIptal()
     * @uses KDesiKgKontrol::setYeniEvrakSeriNo()
     * @param string $tutanakTarihi
     * @param float $evrakSiraNo
     * @param string $evrakTarih
     * @param int $evrakParcaAdedi
     * @param int $olcumParcaAdedi
     * @param float $evrakDesi
     * @param float $olcumDesi
     * @param float $evrakKg
     * @param float $olcumKg
     * @param bool $evrakIptalBaslat
     * @param float $yeniEvrakSiraNo
     * @param bool $isKEKFaturasi
     * @param string $kekTuru
     * @param string $faturalanmamaNedenleri
     * @param \fk_\StructType\KSubePointer $islemSube
     * @param \fk_\StructType\KSubePointer $cikisSube
     * @param \fk_\StructType\KSubePointer $cikisBolge
     * @param \fk_\StructType\KSubePointer $varisSube
     * @param \fk_\StructType\KAracKaraPointer $arac
     * @param string $plaka
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @param string $evrakSeriNo
     * @param string $aciklama
     * @param \fk_\StructType\KEvrakIptalPointer $evrakIptal
     * @param string $yeniEvrakSeriNo
     */
    public function __construct($tutanakTarihi = null, $evrakSiraNo = null, $evrakTarih = null, $evrakParcaAdedi = null, $olcumParcaAdedi = null, $evrakDesi = null, $olcumDesi = null, $evrakKg = null, $olcumKg = null, $evrakIptalBaslat = null, $yeniEvrakSiraNo = null, $isKEKFaturasi = null, $kekTuru = null, $faturalanmamaNedenleri = null, \fk_\StructType\KSubePointer $islemSube = null, \fk_\StructType\KSubePointer $cikisSube = null, \fk_\StructType\KSubePointer $cikisBolge = null, \fk_\StructType\KSubePointer $varisSube = null, \fk_\StructType\KAracKaraPointer $arac = null, $plaka = null, \fk_\StructType\KTesellumPointer $tesellum = null, \fk_\StructType\KFaturaPointer $fatura = null, $evrakSeriNo = null, $aciklama = null, \fk_\StructType\KEvrakIptalPointer $evrakIptal = null, $yeniEvrakSeriNo = null)
    {
        $this
            ->setTutanakTarihi($tutanakTarihi)
            ->setEvrakSiraNo($evrakSiraNo)
            ->setEvrakTarih($evrakTarih)
            ->setEvrakParcaAdedi($evrakParcaAdedi)
            ->setOlcumParcaAdedi($olcumParcaAdedi)
            ->setEvrakDesi($evrakDesi)
            ->setOlcumDesi($olcumDesi)
            ->setEvrakKg($evrakKg)
            ->setOlcumKg($olcumKg)
            ->setEvrakIptalBaslat($evrakIptalBaslat)
            ->setYeniEvrakSiraNo($yeniEvrakSiraNo)
            ->setIsKEKFaturasi($isKEKFaturasi)
            ->setKekTuru($kekTuru)
            ->setFaturalanmamaNedenleri($faturalanmamaNedenleri)
            ->setIslemSube($islemSube)
            ->setCikisSube($cikisSube)
            ->setCikisBolge($cikisBolge)
            ->setVarisSube($varisSube)
            ->setArac($arac)
            ->setPlaka($plaka)
            ->setTesellum($tesellum)
            ->setFatura($fatura)
            ->setEvrakSeriNo($evrakSeriNo)
            ->setAciklama($aciklama)
            ->setEvrakIptal($evrakIptal)
            ->setYeniEvrakSeriNo($yeniEvrakSeriNo);
    }
    /**
     * Get TutanakTarihi value
     * @return string
     */
    public function getTutanakTarihi()
    {
        return $this->TutanakTarihi;
    }
    /**
     * Set TutanakTarihi value
     * @param string $tutanakTarihi
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setTutanakTarihi($tutanakTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($tutanakTarihi) && !is_string($tutanakTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tutanakTarihi, true), gettype($tutanakTarihi)), __LINE__);
        }
        $this->TutanakTarihi = $tutanakTarihi;
        return $this;
    }
    /**
     * Get EvrakSiraNo value
     * @return float
     */
    public function getEvrakSiraNo()
    {
        return $this->EvrakSiraNo;
    }
    /**
     * Set EvrakSiraNo value
     * @param float $evrakSiraNo
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakSiraNo($evrakSiraNo = null)
    {
        // validation for constraint: float
        if (!is_null($evrakSiraNo) && !(is_float($evrakSiraNo) || is_numeric($evrakSiraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evrakSiraNo, true), gettype($evrakSiraNo)), __LINE__);
        }
        $this->EvrakSiraNo = $evrakSiraNo;
        return $this;
    }
    /**
     * Get EvrakTarih value
     * @return string
     */
    public function getEvrakTarih()
    {
        return $this->EvrakTarih;
    }
    /**
     * Set EvrakTarih value
     * @param string $evrakTarih
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakTarih($evrakTarih = null)
    {
        // validation for constraint: string
        if (!is_null($evrakTarih) && !is_string($evrakTarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakTarih, true), gettype($evrakTarih)), __LINE__);
        }
        $this->EvrakTarih = $evrakTarih;
        return $this;
    }
    /**
     * Get EvrakParcaAdedi value
     * @return int
     */
    public function getEvrakParcaAdedi()
    {
        return $this->EvrakParcaAdedi;
    }
    /**
     * Set EvrakParcaAdedi value
     * @param int $evrakParcaAdedi
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakParcaAdedi($evrakParcaAdedi = null)
    {
        // validation for constraint: int
        if (!is_null($evrakParcaAdedi) && !(is_int($evrakParcaAdedi) || ctype_digit($evrakParcaAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evrakParcaAdedi, true), gettype($evrakParcaAdedi)), __LINE__);
        }
        $this->EvrakParcaAdedi = $evrakParcaAdedi;
        return $this;
    }
    /**
     * Get OlcumParcaAdedi value
     * @return int
     */
    public function getOlcumParcaAdedi()
    {
        return $this->OlcumParcaAdedi;
    }
    /**
     * Set OlcumParcaAdedi value
     * @param int $olcumParcaAdedi
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setOlcumParcaAdedi($olcumParcaAdedi = null)
    {
        // validation for constraint: int
        if (!is_null($olcumParcaAdedi) && !(is_int($olcumParcaAdedi) || ctype_digit($olcumParcaAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($olcumParcaAdedi, true), gettype($olcumParcaAdedi)), __LINE__);
        }
        $this->OlcumParcaAdedi = $olcumParcaAdedi;
        return $this;
    }
    /**
     * Get EvrakDesi value
     * @return float
     */
    public function getEvrakDesi()
    {
        return $this->EvrakDesi;
    }
    /**
     * Set EvrakDesi value
     * @param float $evrakDesi
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakDesi($evrakDesi = null)
    {
        // validation for constraint: float
        if (!is_null($evrakDesi) && !(is_float($evrakDesi) || is_numeric($evrakDesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evrakDesi, true), gettype($evrakDesi)), __LINE__);
        }
        $this->EvrakDesi = $evrakDesi;
        return $this;
    }
    /**
     * Get OlcumDesi value
     * @return float
     */
    public function getOlcumDesi()
    {
        return $this->OlcumDesi;
    }
    /**
     * Set OlcumDesi value
     * @param float $olcumDesi
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setOlcumDesi($olcumDesi = null)
    {
        // validation for constraint: float
        if (!is_null($olcumDesi) && !(is_float($olcumDesi) || is_numeric($olcumDesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($olcumDesi, true), gettype($olcumDesi)), __LINE__);
        }
        $this->OlcumDesi = $olcumDesi;
        return $this;
    }
    /**
     * Get EvrakKg value
     * @return float
     */
    public function getEvrakKg()
    {
        return $this->EvrakKg;
    }
    /**
     * Set EvrakKg value
     * @param float $evrakKg
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakKg($evrakKg = null)
    {
        // validation for constraint: float
        if (!is_null($evrakKg) && !(is_float($evrakKg) || is_numeric($evrakKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evrakKg, true), gettype($evrakKg)), __LINE__);
        }
        $this->EvrakKg = $evrakKg;
        return $this;
    }
    /**
     * Get OlcumKg value
     * @return float
     */
    public function getOlcumKg()
    {
        return $this->OlcumKg;
    }
    /**
     * Set OlcumKg value
     * @param float $olcumKg
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setOlcumKg($olcumKg = null)
    {
        // validation for constraint: float
        if (!is_null($olcumKg) && !(is_float($olcumKg) || is_numeric($olcumKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($olcumKg, true), gettype($olcumKg)), __LINE__);
        }
        $this->OlcumKg = $olcumKg;
        return $this;
    }
    /**
     * Get EvrakIptalBaslat value
     * @return bool
     */
    public function getEvrakIptalBaslat()
    {
        return $this->EvrakIptalBaslat;
    }
    /**
     * Set EvrakIptalBaslat value
     * @param bool $evrakIptalBaslat
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakIptalBaslat($evrakIptalBaslat = null)
    {
        // validation for constraint: boolean
        if (!is_null($evrakIptalBaslat) && !is_bool($evrakIptalBaslat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($evrakIptalBaslat, true), gettype($evrakIptalBaslat)), __LINE__);
        }
        $this->EvrakIptalBaslat = $evrakIptalBaslat;
        return $this;
    }
    /**
     * Get YeniEvrakSiraNo value
     * @return float
     */
    public function getYeniEvrakSiraNo()
    {
        return $this->YeniEvrakSiraNo;
    }
    /**
     * Set YeniEvrakSiraNo value
     * @param float $yeniEvrakSiraNo
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setYeniEvrakSiraNo($yeniEvrakSiraNo = null)
    {
        // validation for constraint: float
        if (!is_null($yeniEvrakSiraNo) && !(is_float($yeniEvrakSiraNo) || is_numeric($yeniEvrakSiraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yeniEvrakSiraNo, true), gettype($yeniEvrakSiraNo)), __LINE__);
        }
        $this->YeniEvrakSiraNo = $yeniEvrakSiraNo;
        return $this;
    }
    /**
     * Get IsKEKFaturasi value
     * @return bool
     */
    public function getIsKEKFaturasi()
    {
        return $this->IsKEKFaturasi;
    }
    /**
     * Set IsKEKFaturasi value
     * @param bool $isKEKFaturasi
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setIsKEKFaturasi($isKEKFaturasi = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKEKFaturasi) && !is_bool($isKEKFaturasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKEKFaturasi, true), gettype($isKEKFaturasi)), __LINE__);
        }
        $this->IsKEKFaturasi = $isKEKFaturasi;
        return $this;
    }
    /**
     * Get KekTuru value
     * @return string
     */
    public function getKekTuru()
    {
        return $this->KekTuru;
    }
    /**
     * Set KekTuru value
     * @uses \fk_\EnumType\KEKTuru::valueIsValid()
     * @uses \fk_\EnumType\KEKTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kekTuru
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setKekTuru($kekTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KEKTuru::valueIsValid($kekTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KEKTuru', is_array($kekTuru) ? implode(', ', $kekTuru) : var_export($kekTuru, true), implode(', ', \fk_\EnumType\KEKTuru::getValidValues())), __LINE__);
        }
        $this->KekTuru = $kekTuru;
        return $this;
    }
    /**
     * Get FaturalanmamaNedenleri value
     * @return string
     */
    public function getFaturalanmamaNedenleri()
    {
        return $this->FaturalanmamaNedenleri;
    }
    /**
     * Set FaturalanmamaNedenleri value
     * @uses \fk_\EnumType\KDesiKgKontrolFaturalasmamaNedeni::valueIsValid()
     * @uses \fk_\EnumType\KDesiKgKontrolFaturalasmamaNedeni::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $faturalanmamaNedenleri
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setFaturalanmamaNedenleri($faturalanmamaNedenleri = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KDesiKgKontrolFaturalasmamaNedeni::valueIsValid($faturalanmamaNedenleri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KDesiKgKontrolFaturalasmamaNedeni', is_array($faturalanmamaNedenleri) ? implode(', ', $faturalanmamaNedenleri) : var_export($faturalanmamaNedenleri, true), implode(', ', \fk_\EnumType\KDesiKgKontrolFaturalasmamaNedeni::getValidValues())), __LINE__);
        }
        $this->FaturalanmamaNedenleri = $faturalanmamaNedenleri;
        return $this;
    }
    /**
     * Get IslemSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getIslemSube()
    {
        return $this->IslemSube;
    }
    /**
     * Set IslemSube value
     * @param \fk_\StructType\KSubePointer $islemSube
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setIslemSube(\fk_\StructType\KSubePointer $islemSube = null)
    {
        $this->IslemSube = $islemSube;
        return $this;
    }
    /**
     * Get CikisSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getCikisSube()
    {
        return $this->CikisSube;
    }
    /**
     * Set CikisSube value
     * @param \fk_\StructType\KSubePointer $cikisSube
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setCikisSube(\fk_\StructType\KSubePointer $cikisSube = null)
    {
        $this->CikisSube = $cikisSube;
        return $this;
    }
    /**
     * Get CikisBolge value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getCikisBolge()
    {
        return $this->CikisBolge;
    }
    /**
     * Set CikisBolge value
     * @param \fk_\StructType\KSubePointer $cikisBolge
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setCikisBolge(\fk_\StructType\KSubePointer $cikisBolge = null)
    {
        $this->CikisBolge = $cikisBolge;
        return $this;
    }
    /**
     * Get VarisSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getVarisSube()
    {
        return $this->VarisSube;
    }
    /**
     * Set VarisSube value
     * @param \fk_\StructType\KSubePointer $varisSube
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setVarisSube(\fk_\StructType\KSubePointer $varisSube = null)
    {
        $this->VarisSube = $varisSube;
        return $this;
    }
    /**
     * Get Arac value
     * @return \fk_\StructType\KAracKaraPointer|null
     */
    public function getArac()
    {
        return $this->Arac;
    }
    /**
     * Set Arac value
     * @param \fk_\StructType\KAracKaraPointer $arac
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setArac(\fk_\StructType\KAracKaraPointer $arac = null)
    {
        $this->Arac = $arac;
        return $this;
    }
    /**
     * Get Plaka value
     * @return string|null
     */
    public function getPlaka()
    {
        return $this->Plaka;
    }
    /**
     * Set Plaka value
     * @param string $plaka
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setPlaka($plaka = null)
    {
        // validation for constraint: string
        if (!is_null($plaka) && !is_string($plaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaka, true), gettype($plaka)), __LINE__);
        }
        $this->Plaka = $plaka;
        return $this;
    }
    /**
     * Get Tesellum value
     * @return \fk_\StructType\KTesellumPointer|null
     */
    public function getTesellum()
    {
        return $this->Tesellum;
    }
    /**
     * Set Tesellum value
     * @param \fk_\StructType\KTesellumPointer $tesellum
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setTesellum(\fk_\StructType\KTesellumPointer $tesellum = null)
    {
        $this->Tesellum = $tesellum;
        return $this;
    }
    /**
     * Get Fatura value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getFatura()
    {
        return $this->Fatura;
    }
    /**
     * Set Fatura value
     * @param \fk_\StructType\KFaturaPointer $fatura
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setFatura(\fk_\StructType\KFaturaPointer $fatura = null)
    {
        $this->Fatura = $fatura;
        return $this;
    }
    /**
     * Get EvrakSeriNo value
     * @return string|null
     */
    public function getEvrakSeriNo()
    {
        return $this->EvrakSeriNo;
    }
    /**
     * Set EvrakSeriNo value
     * @param string $evrakSeriNo
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakSeriNo($evrakSeriNo = null)
    {
        // validation for constraint: string
        if (!is_null($evrakSeriNo) && !is_string($evrakSeriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakSeriNo, true), gettype($evrakSeriNo)), __LINE__);
        }
        $this->EvrakSeriNo = $evrakSeriNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get EvrakIptal value
     * @return \fk_\StructType\KEvrakIptalPointer|null
     */
    public function getEvrakIptal()
    {
        return $this->EvrakIptal;
    }
    /**
     * Set EvrakIptal value
     * @param \fk_\StructType\KEvrakIptalPointer $evrakIptal
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setEvrakIptal(\fk_\StructType\KEvrakIptalPointer $evrakIptal = null)
    {
        $this->EvrakIptal = $evrakIptal;
        return $this;
    }
    /**
     * Get YeniEvrakSeriNo value
     * @return string|null
     */
    public function getYeniEvrakSeriNo()
    {
        return $this->YeniEvrakSeriNo;
    }
    /**
     * Set YeniEvrakSeriNo value
     * @param string $yeniEvrakSeriNo
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public function setYeniEvrakSeriNo($yeniEvrakSeriNo = null)
    {
        // validation for constraint: string
        if (!is_null($yeniEvrakSeriNo) && !is_string($yeniEvrakSeriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yeniEvrakSeriNo, true), gettype($yeniEvrakSeriNo)), __LINE__);
        }
        $this->YeniEvrakSeriNo = $yeniEvrakSeriNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KDesiKgKontrol
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
