<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KCariMail StructType
 * @subpackage Structs
 */
class KCariMail extends Entity
{
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Turu;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The Sozlesme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSozlesmePointer
     */
    public $Sozlesme;
    /**
     * Constructor method for KCariMail
     * @uses KCariMail::setTuru()
     * @uses KCariMail::setMail()
     * @uses KCariMail::setCarisi()
     * @uses KCariMail::setSozlesme()
     * @param string $turu
     * @param string $mail
     * @param \fk_\StructType\KCariPointer $carisi
     * @param \fk_\StructType\KSozlesmePointer $sozlesme
     */
    public function __construct($turu = null, $mail = null, \fk_\StructType\KCariPointer $carisi = null, \fk_\StructType\KSozlesmePointer $sozlesme = null)
    {
        $this
            ->setTuru($turu)
            ->setMail($mail)
            ->setCarisi($carisi)
            ->setSozlesme($sozlesme);
    }
    /**
     * Get Turu value
     * @return string
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @uses \fk_\EnumType\KCariMailTuru::valueIsValid()
     * @uses \fk_\EnumType\KCariMailTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $turu
     * @return \fk_\StructType\KCariMail
     */
    public function setTuru($turu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KCariMailTuru::valueIsValid($turu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KCariMailTuru', is_array($turu) ? implode(', ', $turu) : var_export($turu, true), implode(', ', \fk_\EnumType\KCariMailTuru::getValidValues())), __LINE__);
        }
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \fk_\StructType\KCariMail
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \fk_\StructType\KCariPointer $carisi
     * @return \fk_\StructType\KCariMail
     */
    public function setCarisi(\fk_\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get Sozlesme value
     * @return \fk_\StructType\KSozlesmePointer|null
     */
    public function getSozlesme()
    {
        return $this->Sozlesme;
    }
    /**
     * Set Sozlesme value
     * @param \fk_\StructType\KSozlesmePointer $sozlesme
     * @return \fk_\StructType\KCariMail
     */
    public function setSozlesme(\fk_\StructType\KSozlesmePointer $sozlesme = null)
    {
        $this->Sozlesme = $sozlesme;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KCariMail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
