<?php

namespace fk_\EnumType;

/**
 * This class stands for GonderenSubeCalismaSekli EnumType
 * @subpackage Enumerations
 */
class GonderenSubeCalismaSekli
{
    /**
     * Constant for value 'ParamaetrelereBagliCalissin'
     * @return string 'ParamaetrelereBagliCalissin'
     */
    const VALUE_PARAMAETRELERE_BAGLI_CALISSIN = 'ParamaetrelereBagliCalissin';
    /**
     * Constant for value 'EFaturaCarisiGonderenSubeTesellumdenAlinsin'
     * @return string 'EFaturaCarisiGonderenSubeTesellumdenAlinsin'
     */
    const VALUE_EFATURA_CARISI_GONDEREN_SUBE_TESELLUMDEN_ALINSIN = 'EFaturaCarisiGonderenSubeTesellumdenAlinsin';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PARAMAETRELERE_BAGLI_CALISSIN
     * @uses self::VALUE_EFATURA_CARISI_GONDEREN_SUBE_TESELLUMDEN_ALINSIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PARAMAETRELERE_BAGLI_CALISSIN,
            self::VALUE_EFATURA_CARISI_GONDEREN_SUBE_TESELLUMDEN_ALINSIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
