<?php

namespace fk_\EnumType;

/**
 * This class stands for ProjeDurumu EnumType
 * @subpackage Enumerations
 */
class ProjeDurumu
{
    /**
     * Constant for value 'DevamEdiyor'
     * @return string 'DevamEdiyor'
     */
    const VALUE_DEVAM_EDIYOR = 'DevamEdiyor';
    /**
     * Constant for value 'Tamamlandi'
     * @return string 'Tamamlandi'
     */
    const VALUE_TAMAMLANDI = 'Tamamlandi';
    /**
     * Constant for value 'İptal'
     * @return string 'İptal'
     */
    const VALUE_İPTAL = 'İptal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEVAM_EDIYOR
     * @uses self::VALUE_TAMAMLANDI
     * @uses self::VALUE_İPTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEVAM_EDIYOR,
            self::VALUE_TAMAMLANDI,
            self::VALUE_İPTAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
