<?php

namespace fk_\EnumType;

/**
 * This class stands for KMaliDurum EnumType
 * @subpackage Enumerations
 */
class KMaliDurum
{
    /**
     * Constant for value 'MaliDegeriVar'
     * @return string 'MaliDegeriVar'
     */
    const VALUE_MALI_DEGERI_VAR = 'MaliDegeriVar';
    /**
     * Constant for value 'MaliDegeriYok'
     * @return string 'MaliDegeriYok'
     */
    const VALUE_MALI_DEGERI_YOK = 'MaliDegeriYok';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MALI_DEGERI_VAR
     * @uses self::VALUE_MALI_DEGERI_YOK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MALI_DEGERI_VAR,
            self::VALUE_MALI_DEGERI_YOK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
